/*
 * Decompiled with CFR 0.152.
 */
package net.model3.newfile;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import net.model3.chrono.DateTime;
import net.model3.collections.ListX;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.text.ThreadSafeSimpleDateFormat;

public abstract class Path<T extends Path>
implements Serializable {
    private static final long serialVersionUID = 6722355639765978634L;
    private static final Logger logger = LoggerHelper.getLogger();
    private File impl_;
    private boolean isCanonical_ = false;
    private String canonicalPath_;
    private static List<Character> _forbiddenChar = ListX.create(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf(':'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'));
    public static final DateFormat THREADSAFE_DATE_FORMATTER = new ThreadSafeSimpleDateFormat("yyyy-MM-dd-EEE_HH-mm-ss");

    protected Path(File file, boolean bl) {
        this.impl_ = file;
        this.isCanonical_ = bl;
    }

    public Directory getParent() {
        File file = this.asCanonicalFile().getParentFile();
        if (file == null) {
            return null;
        }
        return new Directory(file, true);
    }

    public boolean renameTo(T t) {
        if (((Path)t).exists()) {
            throw new RuntimeException("unable to rename " + this.getCanonicalPath() + " to " + ((Path)t).getCanonicalPath() + " to file already exists.");
        }
        boolean bl = this.impl_.renameTo(((Path)t).getImpl());
        if (!bl) {
            throw new RuntimeException("unable to rename " + this.getCanonicalPath() + " to " + ((Path)t).getCanonicalPath());
        }
        logger.trace((Object)("renamed " + this.getCanonicalPath() + " to " + ((Path)t).getCanonicalPath()));
        return bl;
    }

    public boolean sameDrive(Path path) {
        String string = path.getCanonicalPath().substring(0, 2);
        String string2 = this.getCanonicalPath().substring(0, 2);
        return string.equalsIgnoreCase(string2);
    }

    public File asFile() {
        return this.impl_;
    }

    public File asCanonicalFile() {
        if (this.isCanonical_) {
            return this.asFile();
        }
        try {
            return this.impl_.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(this.getCanonicalPath());
        }
    }

    public String getName() {
        return this.getImpl().getName();
    }

    public String getPath() {
        return this.getImpl().getPath();
    }

    public String getCanonicalPath() {
        if (this.canonicalPath_ == null) {
            try {
                this.canonicalPath_ = this.getImpl().getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.warn((Object)("unable to get canonical path for " + this.impl_.getAbsolutePath()));
                this.canonicalPath_ = this.impl_.getAbsolutePath();
            }
        }
        return this.canonicalPath_;
    }

    public String getPathRelativeTo(Directory directory) {
        String string = directory.getCanonicalPath();
        String string2 = this.getCanonicalPath();
        if (string2.equals(string)) {
            return "";
        }
        if (string2.startsWith(string)) {
            String string3 = string2.substring(string.length() + 1);
            return string3;
        }
        throw new RuntimeException("file " + string2 + " not in path " + string);
    }

    public URL toURL() {
        try {
            return this.impl_.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw ExceptionPropagator.wrap(malformedURLException);
        }
    }

    public void delete() {
        logger.trace((Object)("deleting " + this.getCanonicalPath()));
        if (this.exists()) {
            boolean bl = this.impl_.delete();
            if (this.exists() && !bl) {
                throw new RuntimeException("unable to delete " + this.getCanonicalPath());
            }
        }
    }

    public DateTime getLastModified() {
        return new DateTime(this.getImpl().lastModified());
    }

    public void setLastModified(DateTime dateTime) {
        this.getImpl().setLastModified(dateTime.inMillis());
    }

    public boolean isCanonical() {
        return this.isCanonical_;
    }

    public boolean isRelative() {
        return !this.impl_.isAbsolute();
    }

    public boolean isAbsolute() {
        return this.impl_.isAbsolute();
    }

    protected File getImpl() {
        return this.impl_;
    }

    public abstract boolean isDirectory();

    public int hashCode() {
        return this.getCanonicalPath().hashCode();
    }

    public abstract boolean equals(Object var1);

    public abstract boolean exists();

    public String toString() {
        return this.getImpl().getPath();
    }

    public static String scrubFileName(String string) {
        String string2 = string;
        for (Character c : _forbiddenChar) {
            string2 = string2.replace(c.charValue(), ' ');
        }
        return string2.replaceAll("\\s", "");
    }

    public static String getFileSystemCompatibleTimestamp() {
        return Path.getFileSystemCompatibleTimestamp(new Date());
    }

    public String getBaseFilename() {
        int n;
        String string = this.getCanonicalPath();
        int n2 = string.lastIndexOf(46);
        if (n2 < (n = string.lastIndexOf(File.separatorChar))) {
            n2 = string.length();
        }
        return string.substring(n + 1, n2);
    }

    public static String getFileSystemCompatibleTimestamp(Date date) {
        return THREADSAFE_DATE_FORMATTER.format(date);
    }

    public static DateFormat getFileSystemCompatibleDateFormat() {
        return THREADSAFE_DATE_FORMATTER;
    }
}

