/*
 * Decompiled with CFR 0.152.
 */
package net.model3.newfile;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.model3.io.Pipe;
import net.model3.io.StreamHelper;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.Pair;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.Directory;
import net.model3.newfile.Path;
import net.model3.util.Crypto;

public class File
extends Path<File> {
    private static final long serialVersionUID = -5311069095907716790L;
    private static final Logger logger = LoggerHelper.getLogger();

    public File(java.io.File file, String string) {
        this(new java.io.File(file, string));
    }

    public File(Directory directory, String string) {
        this(new java.io.File(directory.getImpl(), string));
    }

    public File(URI uRI) {
        this(new java.io.File(uRI));
    }

    public File(java.io.File file) {
        this(file, false);
    }

    private File(java.io.File file, boolean bl) {
        super(file, bl);
    }

    public File(String string) {
        this(new java.io.File(string));
    }

    public File(URL uRL) {
        this(UrlX.toURI(uRL));
    }

    public File(String string, String string2) {
        this(new java.io.File(string), string2);
    }

    public FileWriter createWriter() {
        try {
            return new FileWriter(this.asFile());
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public String convertToClassname(Directory directory) {
        String string = this.getParent().getPathRelativeTo(directory);
        string = string.replace(java.io.File.separator, ".");
        String string2 = this.getBaseFilename();
        return string + "." + string2;
    }

    public BufferedReader createReader() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getImpl()));
            return bufferedReader;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public FileInputStream createInputStream() {
        try {
            if (!this.exists()) {
                throw new FileNotFoundException(this.getCanonicalPath());
            }
            FileInputStream fileInputStream = new FileInputStream(this.getImpl());
            return fileInputStream;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public FileOutputStream createOutputStream(boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getImpl(), bl);
            return fileOutputStream;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public PrintStream createPrintStream() {
        return this.createPrintStream(false);
    }

    public PrintStream createPrintStream(boolean bl) {
        return new PrintStream(this.createOutputStream(bl));
    }

    public void copyFileTo(File file) {
        if (!this.exists()) {
            throw new RuntimeException("source file not found " + this.getCanonicalPath());
        }
        logger.trace((Object)("copying " + this.getCanonicalPath() + " to " + file.getCanonicalPath()));
        try {
            int n;
            file.getParent().makeDirectories();
            FileInputStream fileInputStream = new FileInputStream(this.getImpl());
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file.getImpl());
            byte[] byArray = new byte[100000];
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                if (byArray.length == n) continue;
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            file.setLastModified(this.getLastModified());
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public String getExtension() {
        String string = this.getCanonicalPath();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(java.io.File.separatorChar);
        if (n > 0 && n > n2) {
            return string.substring(n + 1);
        }
        return "";
    }

    public String getPathRelativeTo(File file) {
        String string = file.getCanonicalPath();
        String string2 = this.getCanonicalPath();
        if (string2.equals(string)) {
            return "";
        }
        if (string2.startsWith(string)) {
            String string3 = string2.substring(string.length() + 1);
            return string3;
        }
        throw new RuntimeException("file " + string2 + " not in path " + string);
    }

    public FileReader createFileReader() {
        try {
            return new FileReader(this.getImpl());
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public FileOutputStream createOutputStream() {
        try {
            if (!this.getParent().exists()) {
                this.getParent().makeDirectories();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.asCanonicalFile());
            return fileOutputStream;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public boolean sameDrive(File file) {
        String string = file.getCanonicalPath().substring(0, 2);
        String string2 = this.getCanonicalPath().substring(0, 2);
        return string.equalsIgnoreCase(string2);
    }

    public void moveTo(File file) {
        if (this.sameDrive(file)) {
            this.renameTo(file);
        } else {
            this.copyFileTo(file);
            this.delete();
        }
    }

    public void moveTo(Directory directory) {
        this.moveTo(new File(directory, this.getName()));
    }

    public List<String> readLines() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getImpl()));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public long length() {
        return this.getImpl().length();
    }

    public byte[] readBytes() {
        if (!this.exists()) {
            throw new RuntimeException(this.getCanonicalPath() + " file not found.");
        }
        byte[] byArray = new byte[(int)this.length()];
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.getImpl()));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
        return byArray;
    }

    public String readText() {
        return new String(this.readBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String[] stringArray) {
        try (PrintStream printStream = this.createPrintStream();){
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                printStream.println(string);
            }
        }
    }

    public void write(InputStream inputStream) {
        new Pipe(inputStream, this.createOutputStream()).run();
    }

    public void write(byte[] byArray) {
        this.write(byArray, false);
    }

    public void write(String string, boolean bl) {
        this.write(string.getBytes(), bl);
    }

    public void write(String string) {
        this.write(string, false);
    }

    public void writeObject(Object object) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.createOutputStream());
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public Object readObject() {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(this.createInputStream());
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            StreamHelper.forcedClose(objectInputStream);
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public void write(Iterable<String> iterable) {
        this.write(iterable, false);
    }

    public void write(Iterable<String> iterable, boolean bl) {
        String string = "";
        Iterator<String> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + "\n";
        }
        this.write(string, bl);
    }

    public void write(byte[] byArray, boolean bl) {
        try {
            FileOutputStream fileOutputStream = this.createOutputStream();
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nioCopyTo(File file) {
        java.io.File file2 = file.getImpl();
        java.io.File file3 = this.getImpl();
        try {
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileChannel fileChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            try {
                fileChannel = new FileInputStream(file3).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
                ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
            }
            finally {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
            }
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            return file.getCanonicalPath().equals(this.getCanonicalPath());
        }
        return false;
    }

    @Override
    public boolean exists() {
        return this.getImpl().exists() && this.getImpl().isFile();
    }

    public byte[] calculateMd5() {
        return Crypto.calculateMd5(this.readBytes());
    }

    public byte[] calculateSha() {
        return Crypto.calculateSha(this.readBytes());
    }

    public Pair<byte[], byte[]> calculateMd5AndSha() {
        byte[] byArray = this.readBytes();
        byte[] byArray2 = Crypto.calculateMd5(byArray);
        byte[] byArray3 = Crypto.calculateSha(byArray);
        return new Pair<byte[], byte[]>(byArray2, byArray3);
    }

    @Override
    public String getPath() {
        return this.getImpl().getPath();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }
}

