/*
 * Decompiled with CFR 0.152.
 */
package net.model3.newfile;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.File;
import net.model3.newfile.Path;
import net.model3.newfile.selector.FileFilterSelector;
import net.model3.newfile.selector.Selector;

public class Directory
extends Path<Directory> {
    private static final long serialVersionUID = 1523703348853458018L;
    private static final Logger logger = LoggerHelper.getLogger();

    public Directory(java.io.File file, String string) {
        this(new java.io.File(file, string));
    }

    public Directory(URI uRI) {
        this(new java.io.File(uRI));
    }

    public Directory(java.io.File file) {
        this(file, false);
    }

    protected Directory(java.io.File file, boolean bl) {
        super(file, bl);
    }

    public Directory(String string) {
        this(new java.io.File(string));
    }

    public Directory(URL uRL) {
        this(UrlX.toURI(uRL));
    }

    public Directory(String string, String string2) {
        this(new java.io.File(string), string2);
    }

    public Directory(Directory directory, String string) {
        this(directory.getImpl(), string);
    }

    public void copyTo(Directory directory) {
        Path path;
        logger.trace((Object)("copying diectory " + this.getCanonicalPath() + " to " + directory.getCanonicalPath()));
        directory.makeDirectories();
        for (File path2 : this.files()) {
            path = directory.file(path2.getName());
            path2.copyFileTo((File)path);
        }
        for (Directory directory2 : this.subDirectories()) {
            path = directory.subDirectory(directory2.getName());
            directory2.copyTo((Directory)path);
        }
    }

    public List<File> files(boolean bl, String string) {
        return this.files(bl, new ArrayList(), string);
    }

    public List<File> files() {
        return this.files(false, new ArrayList(), null);
    }

    public List<File> filesRecursive() {
        return this.files(true, new ArrayList(), null);
    }

    private List<File> files(boolean bl, List list, String string) {
        block6: {
            java.io.File[] fileArray = this.getImpl().listFiles();
            if (fileArray == null) break block6;
            if (string == null) {
                for (java.io.File file : fileArray) {
                    if (file.isFile()) {
                        list.add(new File(file));
                        continue;
                    }
                    if (!bl || !file.isDirectory()) continue;
                    new Directory(file).files(true, list, string);
                }
            } else {
                for (java.io.File file : fileArray) {
                    if (file.isFile()) {
                        File file2 = new File(file);
                        if (!file2.getExtension().equals(string)) continue;
                        list.add(file2);
                        continue;
                    }
                    if (!bl || !file.isDirectory()) continue;
                    new Directory(file).files(true, list, string);
                }
            }
        }
        return list;
    }

    public List<Directory> subdirs() {
        return this.subDirectories();
    }

    public List<Directory> subdirsRecurse() {
        return this.subDirectoriesRecursive();
    }

    public List<Directory> subDirectories() {
        return this.subDirectories(false, new ArrayList<Directory>());
    }

    public List<Directory> subDirectoriesRecursive() {
        return this.subDirectories(true, new ArrayList<Directory>());
    }

    private List<Directory> subDirectories(boolean bl, List<Directory> list) {
        java.io.File[] fileArray = this.getImpl().listFiles();
        if (fileArray != null) {
            for (java.io.File file : fileArray) {
                if (!file.isDirectory()) continue;
                Directory directory = new Directory(file);
                list.add(directory);
                if (!bl) continue;
                directory.subDirectories(true, list);
            }
        }
        return list;
    }

    public List<Path<?>> paths() {
        return this.paths(false, new ArrayList());
    }

    public List<Path<?>> pathsRecurse() {
        return this.paths(true, new ArrayList());
    }

    private List<Path<?>> paths(boolean bl, List<Path<?>> list) {
        java.io.File[] fileArray = this.getImpl().listFiles();
        if (fileArray != null) {
            for (java.io.File file : fileArray) {
                if (file.isDirectory()) {
                    Directory directory = new Directory(file);
                    list.add(directory);
                    if (!bl) continue;
                    directory.paths(true, list);
                    continue;
                }
                list.add(new File(file));
            }
        }
        return list;
    }

    private static void loadFileLists(Directory directory, Directory directory2, List<File> list, List<Directory> list2, Selector selector, boolean bl, boolean bl2) {
        boolean bl3;
        List<Path> list3;
        if (selector == null) {
            selector = FileFilterSelector.ALWAYS_TRUE_SELECTOR;
        }
        if (!directory2.exists()) {
            throw new RuntimeException(directory2.getCanonicalPath() + " is not a directory.");
        }
        if (list != null) {
            list3 = directory2.files();
            for (File path : list3) {
                bl3 = selector.isSelected(directory, path);
                if (!bl3) continue;
                list.add(path);
            }
        }
        if (list2 != null || bl) {
            list3 = directory2.subDirectories();
            for (Directory directory3 : list3) {
                bl3 = selector.isSelected(directory, directory3);
                if (bl3 && list2 != null) {
                    list2.add(directory3);
                }
                if (!bl || !bl2 && !bl3) continue;
                Directory.loadFileLists(directory, directory3, list, list2, selector, bl, bl2);
            }
        }
    }

    public boolean startsWith(Directory directory) {
        return StringX.startsWith(this.getCanonicalPath(), directory.getCanonicalPath(), false);
    }

    public Directory makeDirectories() {
        this.makeDirectories(true);
        return this;
    }

    public Directory makeDirectory() {
        this.makeDirectories(false);
        return this;
    }

    private boolean makeDirectories(boolean bl) {
        boolean bl2;
        if (this.exists()) {
            if (this.getImpl().isDirectory()) {
                return false;
            }
            throw new RuntimeException("unable to create directory path already exists as a file " + this.getCanonicalPath());
        }
        if (bl && this.getParent() != null && !this.getParent().exists()) {
            this.getParent().makeDirectories(true);
        }
        if (!(bl2 = this.getImpl().mkdir()) && !this.exists()) {
            throw new RuntimeException("underlying java.io.File.mkdir() returned false when trying to make directory for " + this.getCanonicalPath());
        }
        return bl2;
    }

    public boolean sameDrive(Directory directory) {
        String string = directory.getCanonicalPath().substring(0, 2);
        String string2 = this.getCanonicalPath().substring(0, 2);
        return string.equalsIgnoreCase(string2);
    }

    public void moveTo(Directory directory) {
        if (!this.sameDrive(directory)) {
            throw new RuntimeException("copy and delete moves not supported yet");
        }
        this.renameTo(directory);
    }

    public void deleteTree() {
        this.deleteTree(true);
    }

    public void deleteTree(boolean bl) {
        if (!this.exists()) {
            return;
        }
        RuntimeException runtimeException = null;
        logger.trace((Object)("deleting tree at " + this.getCanonicalPath()));
        List<File> list = this.files();
        for (File object2 : list) {
            try {
                object2.delete();
            }
            catch (RuntimeException directory) {
                if (runtimeException == null) continue;
                logger.warn((Object)("at least one delete failed.  delete failed for " + object2.getCanonicalPath()), (Object)directory);
                runtimeException = directory;
            }
        }
        List<Directory> list2 = this.subDirectories();
        Iterator runtimeException4 = list2.iterator();
        while (runtimeException4.hasNext()) {
            Directory directory = (Directory)runtimeException4.next();
            try {
                directory.deleteTree(true);
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException == null) continue;
                logger.warn((Object)("at least one delete failed for " + directory.getCanonicalPath()), (Object)runtimeException2);
                runtimeException = runtimeException2;
            }
        }
        if (runtimeException == null && bl) {
            try {
                this.delete();
            }
            catch (RuntimeException runtimeException3) {
                logger.warn((Object)("at least one delete failed for " + this.getCanonicalPath()), (Object)runtimeException3);
                runtimeException = runtimeException3;
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public Directory getCanonical() {
        if (this.isCanonical()) {
            return this;
        }
        return new Directory(this.asCanonicalFile(), true);
    }

    @Override
    public boolean exists() {
        return this.getImpl().exists() && this.getImpl().isDirectory();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Directory) {
            Directory directory = (Directory)object;
            return directory.getCanonicalPath().equals(this.getCanonicalPath());
        }
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    public File createTempFile(String string, String string2) {
        try {
            return new File(java.io.File.createTempFile(string, string2, this.asFile()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Directory subDirectory(String string) {
        return new Directory(this, string);
    }

    public Directory subdir(String string) {
        return this.subDirectory(string);
    }

    public Directory subdir(String string, boolean bl) {
        return this.subDirectory(string, bl);
    }

    public Directory subDirectory(String string, boolean bl) {
        Directory directory = new Directory(this, string);
        if (bl) {
            directory.makeDirectories();
        }
        return directory;
    }

    public File file(String string) {
        return new File(this, string);
    }

    public boolean isParentOf(Path path) {
        return path.getCanonicalPath().startsWith(this.getCanonicalPath());
    }

    public static Directory getFirstThatExists(Directory ... directoryArray) {
        for (Directory directory : directoryArray) {
            if (!directory.exists()) continue;
            return directory;
        }
        return null;
    }

    public static Directory getFirstThatExists(String ... stringArray) {
        List<Directory> list = ListX.create();
        for (String string : stringArray) {
            list.add(new Directory(string));
        }
        for (Directory directory : list) {
            if (!directory.exists()) continue;
            return directory;
        }
        return null;
    }

    public static Directory getTempDir() {
        return new Directory(System.getProperty("java.io.tmpdir"));
    }
}

