/*
 * Decompiled with CFR 0.152.
 */
package net.model3.net;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.model3.collections.MapX;
import net.model3.io.BytesBuilder;
import net.model3.lang.ByteSize;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StopWatch;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.DummyLog;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.Crypto;
import net.model3.util.Tokenizer;

public final class UrlX {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final char PATH_SEP = '/';
    public static final String PATH_SEP_STRING = "/";
    private URL canonicalUrl_;
    private String canonicalUrlAsString_;
    private UrlX parentUrl_;
    private boolean directory_;
    private Map<String, String> _parms;

    public UrlX(UrlX urlX, String string) {
        this(urlX + PATH_SEP_STRING + string);
    }

    public UrlX(URL uRL) {
        this.init(uRL, false);
    }

    public UrlX(String string) {
        try {
            this.init(new URL(string), false);
        }
        catch (MalformedURLException malformedURLException) {
            throw ExceptionPropagator.wrap(malformedURLException);
        }
    }

    public UrlX(String string, boolean bl) {
        try {
            this.init(new URL(string), bl);
        }
        catch (MalformedURLException malformedURLException) {
            throw ExceptionPropagator.wrap(malformedURLException);
        }
    }

    public UrlX(URL uRL, boolean bl) {
        this.init(uRL, bl);
    }

    private void init(URL uRL, boolean bl) {
        this.canonicalUrl_ = bl ? uRL : UrlX.resolveToCanonicalUrl(uRL);
        this.canonicalUrlAsString_ = this.canonicalUrl_.toExternalForm();
        this.directory_ = this.canonicalUrlAsString_.endsWith(PATH_SEP_STRING);
    }

    public UrlX child(String string) {
        return new UrlX(this, string);
    }

    public UrlX getRootUrl() {
        try {
            return new UrlX(new URL(this.canonicalUrl_.getProtocol(), this.canonicalUrl_.getHost(), this.canonicalUrl_.getPort(), PATH_SEP_STRING), true);
        }
        catch (MalformedURLException malformedURLException) {
            throw ExceptionPropagator.wrap(malformedURLException);
        }
    }

    public UrlX getParentUrl() {
        return this.getParentUrl(false);
    }

    public int getDepthTo(UrlX urlX) {
        String string = this.getPathRelativeTo(urlX);
        return StringX.countOccurences(string, PATH_SEP_STRING);
    }

    public UrlX subPath(String string) {
        return new UrlX(this, string);
    }

    public String getPathRelativeTo(UrlX urlX) {
        if (urlX.canonicalUrlAsString_.equals(this.canonicalUrlAsString_)) {
            return "";
        }
        if (!this.canonicalUrlAsString_.startsWith(urlX.canonicalUrlAsString_)) {
            throw new RuntimeException(urlX + "  is not a parent of " + this);
        }
        int n = urlX.canonicalUrlAsString_.length();
        if (!urlX.isDirectory()) {
            ++n;
        }
        String string = this.canonicalUrlAsString_.substring(n);
        return string;
    }

    public UrlX resolveHref(String string) {
        try {
            URL uRL;
            if (string.startsWith("javascript:")) {
                return null;
            }
            if (string.indexOf(":") > 0) {
                uRL = new URL(string);
            } else {
                UrlX urlX = string.startsWith(PATH_SEP_STRING) ? this.getRootUrl() : this.getParentUrl(true);
                uRL = new URL(urlX + PATH_SEP_STRING + string);
            }
            return new UrlX(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace((Object)("malformed url resolving href=" + string + "    page=" + this.canonicalUrlAsString_), (Object)malformedURLException);
            return null;
        }
    }

    public UrlX getParentUrl(boolean bl) {
        if (bl && this.directory_) {
            return this;
        }
        if (this.parentUrl_ == null) {
            String string = this.canonicalUrl_.getPath();
            int n = string.length();
            if (this.directory_) {
                if (n == 1 || string.equals(PATH_SEP_STRING)) {
                    return null;
                }
                n -= 2;
            }
            int n2 = string.lastIndexOf(47, n);
            String string2 = string.substring(0, n2 + 1);
            try {
                this.parentUrl_ = new UrlX(new URL(this.canonicalUrl_.getProtocol(), this.canonicalUrl_.getHost(), this.canonicalUrl_.getPort(), string2), true);
            }
            catch (MalformedURLException malformedURLException) {
                throw ExceptionPropagator.wrap(malformedURLException);
            }
        }
        return this.parentUrl_;
    }

    public UrlX findCommonParent(UrlX urlX) {
        for (UrlX urlX2 = urlX; urlX2 != null; urlX2 = urlX2.getParentUrl()) {
            if (!this.canonicalUrlAsString_.startsWith(urlX2.canonicalUrlAsString_)) continue;
            return urlX2;
        }
        return null;
    }

    public boolean isDirectory() {
        return this.directory_;
    }

    public String toString() {
        return this.canonicalUrlAsString_;
    }

    public static URL resolveToCanonicalUrl(URL uRL) {
        CharSequence charSequence;
        String string = uRL.getPath();
        boolean bl = false;
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        Tokenizer tokenizer = new Tokenizer(string, PATH_SEP_STRING);
        while (tokenizer.next()) {
            charSequence = tokenizer.currentToken();
            if (((String)charSequence).length() == 0 || ((String)charSequence).equals(".")) continue;
            if (((String)charSequence).equals("..")) {
                if (arrayList.size() == 0) {
                    bl = true;
                    continue;
                }
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            arrayList.add(charSequence);
        }
        charSequence = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)charSequence).append('/');
            ((StringBuffer)charSequence).append((String)iterator.next());
        }
        if (arrayList.size() == 0 || string.endsWith(PATH_SEP_STRING)) {
            ((StringBuffer)charSequence).append('/');
        }
        if (uRL.getQuery() != null) {
            ((StringBuffer)charSequence).append("?");
            ((StringBuffer)charSequence).append(uRL.getQuery());
        }
        try {
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), ((StringBuffer)charSequence).toString());
            if (bl) {
                logger.warn((Object)("poorly formed URL " + uRL.toString() + "  canonicalized to " + uRL2.toString()));
            }
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            throw ExceptionPropagator.wrap(malformedURLException);
        }
    }

    public boolean equals(Object object) {
        UrlX urlX = (UrlX)object;
        return urlX.canonicalUrlAsString_.equals(this.canonicalUrlAsString_);
    }

    public URL asUrl() {
        return this.canonicalUrl_;
    }

    public byte[] asIbiblioCheckSum() {
        String string = this.getContentAsString();
        String string2 = string.substring(0, 32);
        return Crypto.hexStringToByteArray(string2);
    }

    public String asString() {
        return this.toString();
    }

    public String getRelativeHref(UrlX urlX) {
        UrlX urlX2 = this.findCommonParent(urlX);
        if (urlX2 != null) {
            int n = this.getDepthTo(urlX2);
            String string = urlX.getPathRelativeTo(urlX2);
            StringBuffer stringBuffer = new StringBuffer();
            StringX.appendRepeat(stringBuffer, "../", n);
            stringBuffer.append(string);
            if (stringBuffer.length() == 0) {
                stringBuffer.append("./");
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        return null;
    }

    private BytesBuilder downloadAsBytesBuilder() {
        StopWatch stopWatch = new StopWatch("", Level.OFF, new DummyLog());
        logger.trace((Object)("starting download of " + this));
        BytesBuilder bytesBuilder = new BytesBuilder(this.openStream());
        TimeDuration timeDuration = stopWatch.stop();
        ByteSize byteSize = new ByteSize(bytesBuilder.getByteCount());
        logger.trace((Object)("download of " + this + " " + byteSize + " completed in " + timeDuration + " " + byteSize.asThroughput(timeDuration)));
        return bytesBuilder;
    }

    public String getContentAsString() {
        return this.downloadAsBytesBuilder().asString();
    }

    public byte[] getContentAsBytes() {
        return this.downloadAsBytesBuilder().asBytes();
    }

    public InputStream openStream() {
        try {
            return this.canonicalUrl_.openStream();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public boolean isParentOf(UrlX urlX) {
        return urlX.canonicalUrlAsString_.startsWith(this.canonicalUrlAsString_);
    }

    public boolean isFileProtocol() {
        return this.asString().startsWith("file:");
    }

    public int getPort() {
        int n = this.canonicalUrl_.getPort();
        if (n == -1) {
            if (this.canonicalUrl_.getProtocol().equals("http")) {
                n = 80;
            } else if (this.canonicalUrl_.getProtocol().equals("https")) {
                n = 443;
            } else {
                throw new RuntimeException("unable to determine port for " + this.canonicalUrlAsString_);
            }
        }
        return n;
    }

    public Map<String, String> getParms() {
        if (this._parms == null) {
            String string = this.canonicalUrl_.getQuery();
            Map<String, String> map = MapX.create();
            if (string != null) {
                for (String string2 : string.split("\\?")) {
                    String[] stringArray = string2.split("=");
                    map.put(stringArray[0], stringArray[1]);
                }
            }
            this._parms = Collections.unmodifiableMap(map);
        }
        return this._parms;
    }

    public String getHostnameFromUrl() {
        int n = this.canonicalUrlAsString_.indexOf("//");
        if (n < 0) {
            return null;
        }
        int n2 = this.canonicalUrlAsString_.indexOf(PATH_SEP_STRING, n + 2);
        int n3 = this.canonicalUrlAsString_.indexOf(":", n + 2);
        String string = n3 >= 0 && (n2 < 0 || n3 < n2) ? this.canonicalUrlAsString_.substring(n + 2, n3) : (n2 > 0 ? this.canonicalUrlAsString_.substring(n + 2, n2) : this.canonicalUrlAsString_.substring(n + 2));
        return string;
    }

    public String getFilenamePart() {
        return this.getPathRelativeTo(this.getParentUrl());
    }

    public static URI toURI(URL uRL) {
        try {
            return new URI(uRL.toExternalForm().replace(" ", "%20"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw ExceptionPropagator.wrap(uRISyntaxException);
        }
    }
}

