/*
 * Decompiled with CFR 0.152.
 */
package net.model3.net;

import java.net.Inet4Address;
import java.net.InetAddress;

public class SubnetMask {
    static final int[] _powersOf2 = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    String _addressString;
    InetAddress _inetAddress;
    int _bitCount;
    String _bitString;

    public SubnetMask(String string) {
        if (string.contains("/")) {
            this._addressString = string.split("/")[0];
            this._bitCount = Integer.parseInt(string.split("/")[1]);
        } else {
            this._addressString = string;
            this._bitCount = 32;
        }
        try {
            this._inetAddress = Inet4Address.getByName(this._addressString);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean matches(InetAddress inetAddress) {
        String string = this.getBitString(inetAddress);
        return string.startsWith(this.asBitString());
    }

    String asBitString() {
        if (this._bitString == null) {
            this._bitString = this.getBitString(this._inetAddress).substring(0, this._bitCount);
        }
        return this._bitString;
    }

    String getBitString(InetAddress inetAddress) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : inetAddress.getAddress()) {
            this.addBits(by, stringBuilder);
        }
        return stringBuilder.toString();
    }

    void addBits(byte by, StringBuilder stringBuilder) {
        for (int n : _powersOf2) {
            if ((by & n) == 0) {
                stringBuilder.append("0");
                continue;
            }
            stringBuilder.append("1");
        }
    }
}

