/*
 * Decompiled with CFR 0.152.
 */
package net.model3.net;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class SmtpConfig {
    private static final Logger logger = LoggerHelper.getLogger();
    private String _server;
    private int _port = 25;
    private String _user;
    private String _from;
    private String _password;
    private boolean _useSmtps = false;
    private boolean _startTls = false;
    private boolean _debug = false;
    private boolean _fromMustBeUser = false;

    public static SmtpConfig getDefaultInstance() {
        return DependencyInjector.getInstance(SmtpConfig.class);
    }

    public boolean getDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public boolean getUseSmtps() {
        return this._useSmtps;
    }

    public void setUseSmtps(boolean bl) {
        this._useSmtps = bl;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String string) {
        this._user = string;
    }

    public String getFrom() {
        return this._from;
    }

    public void setFrom(String string) {
        this._from = string;
    }

    public boolean getStartTls() {
        return this._startTls;
    }

    public void setStartTls(boolean bl) {
        this._startTls = bl;
    }

    public Authenticator getAuthenticator() {
        Authenticator authenticator = null;
        authenticator = StringX.isNotBlank(this.getUser()) ? new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SmtpConfig.this._user, SmtpConfig.this._password);
            }
        } : null;
        return authenticator;
    }

    public Properties getJavaMailProperties() {
        Properties properties = new Properties();
        properties.put("mail.debug", String.valueOf(this._debug));
        properties.put("mail.debug.auth", String.valueOf(this._debug));
        if (this._useSmtps && this._startTls) {
            logger.warn((Object)"Either SMTPS or TLS should be used, not both. ");
        }
        if (this._useSmtps) {
            properties.put("mail.smtp.socketFactory.port", String.valueOf(this._port));
            properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (this._startTls) {
            properties.put("mail.smtp.starttls.enable", "true");
        }
        properties.put("mail.smtp.host", this._server);
        properties.put("mail.smtp.port", String.valueOf(this._port));
        if (StringX.isNotBlank(this.getUser())) {
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.user", this.getUser());
            properties.put("mail.smtp.from", this.getFrom());
        }
        return properties;
    }

    public static SmtpConfig createLocalhostPort25NoAuthentication() {
        SmtpConfig smtpConfig = new SmtpConfig();
        smtpConfig._server = "localhost";
        smtpConfig._port = 25;
        smtpConfig._user = null;
        smtpConfig._password = null;
        return smtpConfig;
    }

    public String getServer() {
        return this._server;
    }

    public void setServer(String string) {
        this._server = string;
    }

    public Session createJavaMailSession() {
        Session session = Session.getInstance((Properties)this.getJavaMailProperties(), (Authenticator)this.getAuthenticator());
        session.setDebug(this._debug);
        return session;
    }

    public void setFromMustBeUser(boolean bl) {
        this._fromMustBeUser = bl;
    }

    public boolean getFromMustBeUser() {
        return this._fromMustBeUser;
    }

    public void initializeForGMail(String string, String string2) {
        this.setUser(string);
        this.setPassword(string2);
        this.setServer("smtp.gmail.com");
        this.setFromMustBeUser(true);
        this.setPort(465);
        this.setUseSmtps(true);
    }
}

