/*
 * Decompiled with CFR 0.152.
 */
package net.model3.net;

import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.model3.collections.SetX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.SmtpConfig;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public class EmailMessage
implements Cloneable {
    private static final Logger logger = LoggerHelper.getLogger();
    private String from_ = "";
    private Set<String> _to = SetX.create();
    private Set<String> _cc = SetX.create();
    private Set<String> _bcc = SetX.create();
    private String _subject = "";
    private String _body = "";
    private SmtpConfig _smtpConfig = SmtpConfig.getDefaultInstance();
    private Set<File> _attachments = SetX.create();
    private Set<File> _embeddedImages = SetX.create();
    private Directory _embeddedImageRoot;
    private String _contentType = "text/plain";

    public String getBody() {
        return this._body;
    }

    public void setBody(String string) {
        this._body = string;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setSubject(String string) {
        this._subject = string;
    }

    public String getFrom() {
        return this.from_;
    }

    public void setFrom(String string) {
        this.from_ = string;
    }

    public void addAttachment(File file) {
        this._attachments.add(file);
    }

    public void addEmbeddedImage(File file) {
        this._embeddedImages.add(file);
    }

    public void addTo(String string) {
        this._to.add(string);
    }

    public void addTo(Set<String> set) {
        this._to.addAll(set);
    }

    public void addCc(String string) {
        this._cc.add(string);
    }

    public void addCC(Set<String> set) {
        this._cc.addAll(set);
    }

    public void addBcc(String string) {
        this._bcc.add(string);
    }

    public void addBcc(Set<String> set) {
        this._bcc.addAll(set);
    }

    public SmtpConfig getSmtpConfig() {
        return this._smtpConfig;
    }

    public void setSmtpConfig(SmtpConfig smtpConfig) {
        this._smtpConfig = smtpConfig;
    }

    public EmailMessage clone() {
        EmailMessage emailMessage = new EmailMessage();
        emailMessage._smtpConfig = this._smtpConfig;
        emailMessage._subject = this._subject;
        emailMessage._body = this._body;
        emailMessage.from_ = this.from_;
        emailMessage._to.addAll(this._to);
        emailMessage._cc.addAll(this._cc);
        emailMessage._bcc.addAll(this._bcc);
        return emailMessage;
    }

    public void sendWithSession(Session session) {
        try {
            String string;
            String string2;
            MimeMultipart mimeMultipart = new MimeMultipart();
            MimeMessage mimeMessage = new MimeMessage(session);
            if (this.getSmtpConfig().getFromMustBeUser() && StringX.isNotBlank(this.from_) && !this.from_.equals(this.getSmtpConfig().getUser())) {
                logger.warn((Object)"we must send using the {} user so the specified from user {} will be ignored", (Object)this.getSmtpConfig().getUser(), (Object)this.from_);
            }
            InternetAddress internetAddress = new InternetAddress(this.from_);
            mimeMessage.setFrom((Address)internetAddress);
            mimeMessage.setSubject(this._subject);
            AddressException addressException = null;
            addressException = this.addRecipients(this._to, Message.RecipientType.TO, (Message)mimeMessage, addressException);
            addressException = this.addRecipients(this._cc, Message.RecipientType.CC, (Message)mimeMessage, addressException);
            addressException = this.addRecipients(this._bcc, Message.RecipientType.BCC, (Message)mimeMessage, addressException);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            String string3 = this._body;
            if (this._embeddedImages != null) {
                for (File file : this._embeddedImages) {
                    this._contentType = "text/html";
                    string2 = file.getCanonicalPath().replaceAll("/", "_");
                    string2 = string2.replaceFirst(":", "_");
                    string = file.getPathRelativeTo(this._embeddedImageRoot);
                    string3 = string3.replaceAll(string, "cid:" + string2);
                    MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                    FileDataSource fileDataSource = new FileDataSource(file.asCanonicalFile());
                    mimeBodyPart2.setDataHandler(new DataHandler((DataSource)fileDataSource));
                    mimeBodyPart2.setHeader("Content-ID", "<" + string2 + ">");
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
                }
            }
            mimeBodyPart.setContent((Object)string3, this._contentType);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            if (this._attachments != null) {
                for (File file : this._attachments) {
                    string2 = new MimeBodyPart();
                    string = new FileDataSource(file.getCanonicalPath());
                    string2.setDataHandler(new DataHandler((DataSource)string));
                    string2.setFileName(file.getName());
                    mimeMultipart.addBodyPart((BodyPart)string2);
                }
            }
            mimeMessage.setContent((Object)string3, this._contentType);
            mimeMessage.saveChanges();
            if (this._to.size() + this._cc.size() + this._bcc.size() > 0) {
                logger.debug((Object)("sending message using " + this._smtpConfig.getServer() + ":" + this._smtpConfig.getPort() + " from: " + this.from_ + " to: " + this._to.toString() + " cc: " + this._cc.toString() + " bcc: " + this._bcc.toString() + " subject: " + this._subject));
                Transport transport = session.getTransport("smtp");
                transport.connect();
                mimeMessage.saveChanges();
                transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                transport.close();
            }
            if (addressException != null) {
                throw addressException;
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap("exception occured in send()", exception);
        }
    }

    public void send() {
        Session session = this._smtpConfig.createJavaMailSession();
        this.sendWithSession(session);
    }

    private AddressException addRecipients(Set<String> set, Message.RecipientType recipientType, Message message, AddressException addressException) throws MessagingException {
        for (String string : set) {
            try {
                message.addRecipient(recipientType, (Address)new InternetAddress(string));
            }
            catch (AddressException addressException2) {
                addressException = addressException2;
                logger.warn((Object)("invalid email address " + string), (Object)addressException2);
            }
        }
        return addressException;
    }

    public void setEmbeddedImageRoot(Directory directory) {
        this._embeddedImageRoot = directory;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String string) {
        this._contentType = string;
    }

    public Set<String> getTo() {
        return this._to;
    }

    public Set<String> getBcc() {
        return this._bcc;
    }

    public Set<String> getCc() {
        return this._cc;
    }
}

