/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import java.util.concurrent.Callable;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public class ThreadLocalAppender
extends AppenderSkeleton {
    private static final String DEFAULT_APPENDER_NAME = "ThreadLocalAppender";
    private static final Logger logger = LoggerHelper.getLogger();
    private ThreadLocal<Appender> _appenders = new ThreadLocal();

    public ThreadLocalAppender() {
        this.setName(DEFAULT_APPENDER_NAME);
    }

    public static ThreadLocalAppender get() {
        org.apache.log4j.Logger logger = (org.apache.log4j.Logger)ThreadLocalAppender.logger.getRoot().getDelegate();
        ThreadLocalAppender threadLocalAppender = (ThreadLocalAppender)logger.getAppender(DEFAULT_APPENDER_NAME);
        if (threadLocalAppender == null) {
            threadLocalAppender = new ThreadLocalAppender();
            threadLocalAppender.activateOptions();
            logger.addAppender((Appender)threadLocalAppender);
        }
        return threadLocalAppender;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.getLayout() == null) {
            this.setLayout(new SimpleLoggingConfigurator(null).getDefaultLayout());
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }

    protected void append(LoggingEvent loggingEvent) {
        Appender appender = this.getThreadLocalAppender();
        if (appender != null) {
            appender.doAppend(loggingEvent);
        }
    }

    public void activateAppender(Appender appender, boolean bl) {
        Appender appender2;
        if (appender.getLayout() == null) {
            appender.setLayout(this.getLayout());
        }
        if (bl && appender instanceof OptionHandler) {
            ((OptionHandler)appender).activateOptions();
        }
        if ((appender2 = this.getThreadLocalAppender()) != null) {
            logger.warn((Object)("already has an appender active for this thread " + Thread.currentThread() + "   " + appender2 + "  " + appender));
        }
        this._appenders.set(appender);
    }

    public <T> T withAppender(Appender appender, Callable<T> callable) {
        Appender appender2 = this._appenders.get();
        if (appender2 != null) {
            this._appenders.set(null);
        }
        try {
            T t;
            this.activateAppender(appender, false);
            T t2 = t = callable.call();
            return t2;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked(exception);
        }
        finally {
            this.deactivateAppender(appender2);
        }
    }

    public Appender getThreadLocalAppender() {
        return this._appenders.get();
    }

    public Appender deactivateAppender() {
        return this.deactivateAppender(null);
    }

    Appender deactivateAppender(Appender appender) {
        Appender appender2 = this._appenders.get();
        this._appenders.set(appender);
        return appender2;
    }
}

