/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.net.EmailMessage;
import net.model3.net.SmtpConfig;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class SmtpAppender
extends AppenderSkeleton {
    private String to_;
    private String from_;
    private String subject_;
    private SmtpConfig smtpConfig_;
    private static ExecutorService sendQueue_ = Executors.newSingleThreadExecutor();
    private boolean locationInfo = false;
    private int bufferSize_ = 1024;
    protected CyclicBuffer cyclicBuffer_ = new CyclicBuffer(this.bufferSize_);
    protected TriggeringEventEvaluator evaluator_;
    private TimeDuration blackoutDuration_;
    private volatile boolean inBlackout_ = false;
    private volatile boolean errorsOccurredInBlackout_ = false;

    public SmtpAppender() {
        this(new DefaultEvaluator());
    }

    public SmtpAppender(TriggeringEventEvaluator triggeringEventEvaluator) {
        this.evaluator_ = triggeringEventEvaluator;
    }

    public void activateOptions() {
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        loggingEvent.getThreadName();
        loggingEvent.getNDC();
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        this.cyclicBuffer_.add(loggingEvent);
        if (this.evaluator_.isTriggeringEvent(loggingEvent)) {
            if (!this.inBlackout_) {
                this.sendBuffer();
            } else {
                this.errorsOccurredInBlackout_ = true;
            }
        }
    }

    protected boolean checkEntryConditions() {
        if (this.evaluator_ == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String string) {
        try {
            return new InternetAddress(string);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    InternetAddress[] parseAddress(String string) {
        try {
            return InternetAddress.parse((String)string, (boolean)true);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    public String getTo() {
        if (this.to_ != null) {
            return this.to_;
        }
        return System.getProperty("smtp-appender.to");
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer() {
        Object object;
        Object object2;
        if (this.blackoutDuration_ != null) {
            this.inBlackout_ = true;
            object2 = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (SmtpAppender.this.errorsOccurredInBlackout_) {
                        SmtpAppender smtpAppender = SmtpAppender.this;
                        synchronized (smtpAppender) {
                            SmtpAppender.this.sendBuffer();
                            SmtpAppender.this.errorsOccurredInBlackout_ = false;
                        }
                    } else {
                        SmtpAppender.this.inBlackout_ = true;
                    }
                }
            };
            object = (ThreadScheduler)DependencyInjector.get().getInstance(ThreadScheduler.class);
            ((ThreadScheduler)object).schedule("smtp-blackout", this.blackoutDuration_, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (SmtpAppender.this.errorsOccurredInBlackout_) {
                        SmtpAppender smtpAppender = SmtpAppender.this;
                        synchronized (smtpAppender) {
                            SmtpAppender.this.sendBuffer();
                            SmtpAppender.this.errorsOccurredInBlackout_ = false;
                        }
                    } else {
                        SmtpAppender.this.inBlackout_ = true;
                    }
                }
            });
        }
        try {
            object2 = new StringBuffer();
            object = this.layout.getHeader();
            if (object != null) {
                ((StringBuffer)object2).append((String)object);
            }
            int n = this.cyclicBuffer_.length();
            for (int i = 0; i < n; ++i) {
                String[] stringArray;
                LoggingEvent loggingEvent = this.cyclicBuffer_.get();
                ((StringBuffer)object2).append(this.layout.format(loggingEvent));
                if (!this.layout.ignoresThrowable() || (stringArray = loggingEvent.getThrowableStrRep()) == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    ((StringBuffer)object2).append(stringArray[j]);
                }
            }
            object = this.layout.getFooter();
            if (object != null) {
                ((StringBuffer)object2).append((String)object);
            }
            sendQueue_.execute(new Runnable((StringBuffer)object2){
                final /* synthetic */ StringBuffer val$sbuf;
                {
                    this.val$sbuf = stringBuffer;
                }

                @Override
                public void run() {
                    try {
                        EmailMessage emailMessage = new EmailMessage();
                        emailMessage.setSmtpConfig(SmtpAppender.this.getSmtpConfigForMailing());
                        emailMessage.setFrom(SmtpAppender.this.getFrom());
                        emailMessage.addTo(SmtpAppender.this.getTo());
                        emailMessage.setSubject(SmtpAppender.this.getSubject() + SmtpAppender.getDateString());
                        emailMessage.setBody("<html><pre>" + this.val$sbuf.toString() + "</pre></html>");
                        emailMessage.send();
                    }
                    catch (Exception exception) {
                        LogLog.error((String)"Error occured while sending e-mail notification.", (Throwable)exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            LogLog.error((String)"Error occured while sending e-mail notification.", (Throwable)exception);
        }
    }

    public String getEvaluatorClass() {
        return this.evaluator_ == null ? null : this.evaluator_.getClass().getName();
    }

    public String getFrom() {
        if (this.from_ != null) {
            return this.from_;
        }
        return System.getProperty("smtp-appender.from");
    }

    public String getSubject() {
        if (this.subject_ != null) {
            return this.subject_;
        }
        return System.getProperty("smtp-appender.subject");
    }

    public void setFrom(String string) {
        this.from_ = string;
    }

    public void setSubject(String string) {
        this.subject_ = string;
    }

    public void setSmtpHost(String string) {
        this.getSmtpConfigInstance(true).setServer(string);
    }

    public void setSmtpConfig(SmtpConfig smtpConfig) {
        this.smtpConfig_ = smtpConfig;
    }

    public void setTo(String string) {
        this.to_ = string;
    }

    public void setEvaluatorClass(String string) {
        this.evaluator_ = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName((String)string, TriggeringEventEvaluator.class, (Object)this.evaluator_);
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setSmtpPassword(String string) {
        this.getSmtpConfigInstance(true).setPassword(string);
    }

    public void setSmtpPort(String string) {
        this.getSmtpConfigInstance(true).setPort(Integer.parseInt(string));
    }

    public void setSmtpPort(int n) {
        this.getSmtpConfigInstance(true).setPort(n);
    }

    public void setSmtpUser(String string) {
        this.getSmtpConfigInstance(true).setUser(string);
    }

    public int getBufferSize() {
        return this.bufferSize_;
    }

    public void setBufferSize(int n) {
        this.bufferSize_ = n;
        this.cyclicBuffer_.resize(n);
    }

    public void setBlackoutDuration(String string) {
        this.blackoutDuration_ = new TimeDuration(string);
    }

    public static String getDateString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm Z").format(new Date());
    }

    private SmtpConfig getSmtpConfigForMailing() {
        if (this.smtpConfig_ == null) {
            return SmtpConfig.getDefaultInstance();
        }
        return this.smtpConfig_;
    }

    private SmtpConfig getSmtpConfigInstance(boolean bl) {
        if (bl && this.smtpConfig_ == null) {
            this.smtpConfig_ = new SmtpConfig();
        }
        return this.smtpConfig_;
    }

    static class DefaultEvaluator
    implements TriggeringEventEvaluator {
        DefaultEvaluator() {
        }

        public boolean isTriggeringEvent(LoggingEvent loggingEvent) {
            return loggingEvent.getLevel().isGreaterOrEqual((Priority)Level.WARN);
        }
    }
}

