/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.servlet.AbstractHttpFilter;
import org.apache.log4j.NDC;

@Singleton
public class ServletFilter
extends AbstractHttpFilter {
    private static final Logger logger = LoggerHelper.getLogger();
    boolean _catchExceptions = false;
    boolean _ioExceptionAsDebug = true;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String string;
        String string2 = filterConfig.getInitParameter("catchExceptions");
        if (string2 != null) {
            this._catchExceptions = Boolean.valueOf(string2);
        }
        if ((string = filterConfig.getInitParameter("ioExceptionAsDebug")) != null) {
            this._ioExceptionAsDebug = Boolean.valueOf(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        NDC.push((String)httpServletRequest.getRequestURI());
        logger.debug((Object)"request started  uri = {}", (Object)httpServletRequest.getRequestURI());
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            logger.debug((Object)"request completed  uri = {}", (Object)httpServletRequest.getRequestURI());
        }
        catch (Throwable throwable) {
            if (this._ioExceptionAsDebug && (throwable instanceof IOException || ExceptionPropagator.getRootCause(throwable) instanceof IOException)) {
                logger.debug((Object)throwable);
            } else {
                logger.error((Object)throwable);
                if (!this._catchExceptions) {
                    ExceptionPropagator.throwUnchecked(throwable);
                }
            }
        }
        finally {
            NDC.pop();
        }
    }
}

