/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;

public class Model3RepositorySelector
implements RepositorySelector {
    private static Model3RepositorySelector instance_;
    private Map<ClassLoader, LoggerRepository> repositories_ = new HashMap<ClassLoader, LoggerRepository>();
    private LoggerRepository defaultRepository_ = LogManager.getLoggerRepository();

    public static Model3RepositorySelector getInstance() {
        if (instance_ == null) {
            instance_ = new Model3RepositorySelector();
        }
        return instance_;
    }

    private Model3RepositorySelector() {
        LogManager.setRepositorySelector((RepositorySelector)this, (Object)LogManager.getRootLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHierarchyForCurrentClassloader() {
        Map<ClassLoader, LoggerRepository> map = this.repositories_;
        synchronized (map) {
            this.repositories_.remove(Thread.currentThread().getContextClassLoader());
        }
    }

    public void addHierarchyForCurrentClassloader() {
        Hierarchy hierarchy = new Hierarchy((Logger)new RootLogger(Level.TRACE));
        this.addClassLoader(Thread.currentThread().getContextClassLoader(), hierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassLoader(ClassLoader classLoader, Hierarchy hierarchy) {
        Map<ClassLoader, LoggerRepository> map = this.repositories_;
        synchronized (map) {
            this.repositories_.put(classLoader, (LoggerRepository)hierarchy);
        }
    }

    public LoggerRepository getLoggerRepository() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LoggerRepository loggerRepository = this.repositories_.get(classLoader);
        if (loggerRepository == null) {
            return this.defaultRepository_;
        }
        return loggerRepository;
    }
}

