/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import java.util.HashMap;
import java.util.Map;
import net.model3.logging.AbstractLog;
import net.model3.logging.Level;
import net.model3.logging.Log;
import net.model3.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.RootLogger;

public class LogLog4j
extends AbstractLog {
    private static final Map<org.apache.log4j.Level, Level> log4jToModel3LevelMap_ = new HashMap<org.apache.log4j.Level, Level>();
    private Logger delegate_;

    LogLog4j(LogFactory logFactory, Logger logger) {
        super(logFactory, logger.getName());
        this.delegate_ = logger;
    }

    public String toString() {
        return "LogImpl[name=" + this.getName() + "]";
    }

    @Override
    public void setLevel(Level level) {
        this.delegate_.setLevel(LogLog4j.convertToLog4j(level));
    }

    @Override
    public String getName() {
        return this.delegate_.getName();
    }

    @Override
    public Log getParent() {
        Logger logger = (Logger)this.delegate_.getParent();
        if (logger == null) {
            return null;
        }
        if (logger instanceof RootLogger) {
            return this.getLogFactory().getRootLog();
        }
        return this.getLogFactory().getLog(this.delegate_.getParent().getName());
    }

    public static org.apache.log4j.Level convertToLog4j(Level level) {
        return (org.apache.log4j.Level)level.getDelegate();
    }

    public static Level convertToModel3(org.apache.log4j.Level level) {
        return log4jToModel3LevelMap_.get(level);
    }

    public Logger getDelegate() {
        return this.delegate_;
    }

    @Override
    public boolean isRootLog() {
        return this.delegate_.getParent() == null;
    }

    @Override
    public Level getLevel() {
        return LogLog4j.convertToModel3(this.delegate_.getLevel());
    }

    @Override
    public Level getResolvedLevel() {
        return LogLog4j.convertToModel3(this.delegate_.getEffectiveLevel());
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.delegate_.isEnabledFor((Priority)LogLog4j.convertToLog4j(level));
    }

    @Override
    protected void logImpl(Level level, String string, Throwable throwable) {
        this.delegate_.log((Priority)LogLog4j.convertToLog4j(level), (Object)string, throwable);
    }

    static {
        for (Priority priority : org.apache.log4j.Level.getAllPossiblePriorities()) {
            log4jToModel3LevelMap_.put((org.apache.log4j.Level)priority, Level.valueOf(priority.toString()));
        }
    }
}

