/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import com.google.inject.Inject;
import java.io.OutputStreamWriter;
import net.model3.logging.HouseKeeper;
import net.model3.logging.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class HouseKeepingFileAppender
extends WriterAppender {
    private static Logger LOG;
    private HouseKeeper houseKeeper_;

    @Inject
    public HouseKeepingFileAppender(HouseKeeper houseKeeper) {
        this.houseKeeper_ = houseKeeper;
        this.setWriter(new OutputStreamWriter(this.houseKeeper_.getOutputStream()));
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        this.houseKeeper_.checkForHouseKeeping();
        super.subAppend(loggingEvent);
    }

    public void activateOptions() {
        super.activateOptions();
        this.houseKeeper_.activateOptions();
    }

    public void setArchiveDirectory(String string) {
        this.houseKeeper_.setArchiveDirectory(string);
    }

    public void setDatePattern(String string) {
        this.houseKeeper_.setDatePattern(string);
    }

    public void setDaysToKeep(int n) {
        this.houseKeeper_.setDaysToKeep(n);
    }

    public void setFilenamePrefix(String string) {
        this.houseKeeper_.setFilenamePrefix(string);
    }

    public void setFilenameSuffix(String string) {
        this.houseKeeper_.setFilenameSuffix(string);
    }

    public void setKeepFor(String string) {
        this.houseKeeper_.setKeepFor(string);
    }

    public synchronized void close() {
        super.close();
        this.houseKeeper_.shutdown();
    }

    public HouseKeeper getHouseKeeper() {
        return this.houseKeeper_;
    }
}

