/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class EclipseConsoleAppender
extends AppenderSkeleton {
    private PrintStream output_ = new PrintStream(new FileOutputStream(FileDescriptor.out));
    private PrintStream error_ = new PrintStream(new FileOutputStream(FileDescriptor.err));

    public EclipseConsoleAppender() {
        this.setName("eclipse");
    }

    public EclipseConsoleAppender(Layout layout) {
        this.setLayout(layout);
        this.activateOptions();
    }

    public void activateOptions() {
        super.activateOptions();
    }

    protected void append(LoggingEvent loggingEvent) {
        PrintStream printStream = loggingEvent.getLevel().toInt() > 20000 ? this.error_ : this.output_;
        printStream.print(this.getLayout().format(loggingEvent));
        if (this.getLayout().ignoresThrowable() && loggingEvent.getThrowableStrRep() != null) {
            for (int i = 0; i < loggingEvent.getThrowableStrRep().length; ++i) {
                printStream.println(loggingEvent.getThrowableStrRep()[i]);
            }
        }
        printStream.flush();
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

