/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.log4j;

import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.spi.LoggingEvent;

public class CircularBufferAppender
extends AppenderSkeleton {
    private static final Logger LOG = LoggerHelper.getLogger();
    private CyclicBuffer _buffer;
    private int _bufferSize = 1024;

    public CircularBufferAppender() {
    }

    public CircularBufferAppender(int n) {
        this._bufferSize = n;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.getLayout() == null) {
            this.setLayout(new SimpleLoggingConfigurator(null).getDefaultLayout());
        }
        this._buffer = new CyclicBuffer(this._bufferSize);
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }

    protected void append(LoggingEvent loggingEvent) {
        this._buffer.add(loggingEvent);
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        Layout layout = this.getLayout();
        String string = layout.getHeader();
        if (string != null) {
            stringBuilder.append(string);
        }
        int n = this._buffer.length();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            LoggingEvent loggingEvent = this._buffer.get();
            stringBuilder.append(layout.format(loggingEvent));
            if (!layout.ignoresThrowable() || (stringArray = loggingEvent.getThrowableStrRep()) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                stringBuilder.append(stringArray[j]);
                stringBuilder.append("\n");
            }
        }
        string = layout.getFooter();
        if (string != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
        if (this._buffer != null) {
            this._buffer.resize(this._bufferSize);
        }
    }
}

