/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.jdk;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.model3.logging.jdk.BasicFormatter;

public class SystemDotOutConsoleHandler
extends Handler {
    public SystemDotOutConsoleHandler() {
        this.setLevel(Level.FINEST);
        this.setFilter(null);
        this.setFormatter(new BasicFormatter());
    }

    @Override
    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            string = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            System.out.print(string);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
        }
        this.flush();
    }

    @Override
    public void flush() {
        System.out.flush();
    }

    @Override
    public void close() {
        this.flush();
    }
}

