/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.jdk;

import java.util.Map;
import java.util.logging.Logger;
import net.model3.logging.AbstractLog;
import net.model3.logging.Level;
import net.model3.logging.Log;
import net.model3.logging.LogFactory;
import net.model3.logging.jdk.LogFactoryJDK;

public class LogJDK
extends AbstractLog {
    private static final Map<Object, Level> jdkToModel3LevelMap_ = new LogFactoryJDK().getDelegatesToLevelMap();
    private Logger delegate_;

    LogJDK(LogFactory logFactory, Logger logger) {
        super(logFactory, logger.getName());
        this.delegate_ = logger;
    }

    public String toString() {
        return "LogImpl[name=" + this.getName() + "]";
    }

    @Override
    public Level getLevel() {
        if (this.delegate_.getLevel() == null) {
            return null;
        }
        return jdkToModel3LevelMap_.get(this.delegate_.getLevel());
    }

    @Override
    public Level getResolvedLevel() {
        return jdkToModel3LevelMap_.get(this.resolveLevel(this.getDelegate()));
    }

    public java.util.logging.Level resolveLevel(Logger logger) {
        if (logger.getLevel() == null) {
            if (logger.getParent() == null) {
                return java.util.logging.Level.ALL;
            }
            return this.resolveLevel(logger);
        }
        return logger.getLevel();
    }

    @Override
    public void setLevel(Level level) {
        this.delegate_.setLevel((java.util.logging.Level)level.getDelegate());
    }

    @Override
    public String getName() {
        return this.delegate_.getName();
    }

    @Override
    public Log getParent() {
        Logger logger = this.delegate_.getParent();
        if (logger == null) {
            return null;
        }
        return this.getLogFactory().getLog(this.delegate_.getParent().getName());
    }

    public Logger getDelegate() {
        return this.delegate_;
    }

    @Override
    public boolean isRootLog() {
        return this.delegate_.getParent() == null;
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.delegate_.isLoggable((java.util.logging.Level)level.getDelegate());
    }

    @Override
    protected void logImpl(Level level, String string, Throwable throwable) {
        this.delegate_.log((java.util.logging.Level)level.getDelegate(), string, throwable);
    }

    @Override
    public LogFactoryJDK getLogFactory() {
        return (LogFactoryJDK)super.getLogFactory();
    }
}

