/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.jdk;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.model3.logging.jdk.BasicFormatter;

public class EclipseConsoleHandler
extends Handler {
    public EclipseConsoleHandler() {
        this.setLevel(Level.FINEST);
        this.setFilter(null);
        this.setFormatter(new BasicFormatter());
    }

    @Override
    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            string = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            if (logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
                System.err.print(string);
            } else {
                System.out.print(string);
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
        }
        this.flush();
    }

    @Override
    public void flush() {
        System.err.flush();
        System.out.flush();
    }

    @Override
    public void close() {
        this.flush();
    }
}

