/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging.jdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class BasicFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private String fieldSeparator = " -- ";
    private String lineSeparator = "\n";

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.dat.setTime(logRecord.getMillis());
        StringBuffer stringBuffer = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(new Object[]{this.dat}, stringBuffer, (FieldPosition)null);
        stringBuilder.append(stringBuffer);
        stringBuilder.append(this.fieldSeparator);
        stringBuilder.append(Thread.currentThread().getName());
        String string = logRecord.getLevel().getLocalizedName();
        stringBuilder.append(this.fieldSeparator);
        stringBuilder.append(string);
        stringBuilder.append(this.fieldSeparator);
        String string2 = logRecord.getLoggerName();
        if (string2.startsWith("gov.sensornet.isp")) {
            string2 = string2.substring("gov.sensornet.isp".length());
        }
        stringBuilder.append(string2);
        stringBuilder.append(this.fieldSeparator);
        String string3 = this.formatMessage(logRecord);
        stringBuilder.append(string3);
        stringBuilder.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.print("   ");
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuilder.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }
}

