/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import com.google.inject.Injector;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.model3.logging.Level;
import net.model3.logging.LogFactory;
import net.model3.logging.LoggerHelper;
import net.model3.logging.LoggingConfigurator;
import net.model3.logging.log4j.LogFactoryLog4j;
import net.model3.logging.log4j.Model3RepositorySelector;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggerRepository;

public class LoggingDotProperties {
    private Properties properties_;
    private Directory loggingDirectory_;
    private boolean levelsOnly_;
    private Injector _injector;

    public LoggingDotProperties(Injector injector, Properties properties, Directory directory, boolean bl) {
        this._injector = injector;
        this.properties_ = properties;
        this.loggingDirectory_ = directory;
        this.levelsOnly_ = bl;
    }

    public LoggingDotProperties(Injector injector, File file, Directory directory, boolean bl) {
        this._injector = injector;
        this.properties_ = new Properties();
        this.loggingDirectory_ = directory;
        this.levelsOnly_ = bl;
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = file.createInputStream();
                this.properties_.load(fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void init() {
        boolean bl = Boolean.valueOf(this.properties_.getProperty("enable", "true"));
        if (bl) {
            String string;
            if (!this.levelsOnly_) {
                Model3RepositorySelector.getInstance().addHierarchyForCurrentClassloader();
                LoggerRepository loggerRepository = LogManager.getLoggerRepository();
                loggerRepository.resetConfiguration();
                if (LogFactory.getInstance() instanceof LogFactoryLog4j) {
                    ((LogFactoryLog4j)LogFactory.getInstance()).setLoggerRepository(loggerRepository);
                }
                String string2 = this.properties_.getProperty("prefix", "webapp");
                String string3 = this.properties_.getProperty("layout", "%d{ABSOLUTE} | %t | %x | %-5p | %c | %m%n");
                string = this.properties_.getProperty("level", "trace");
                boolean bl2 = Boolean.valueOf(this.properties_.getProperty("houseKeeping", "true"));
                boolean bl3 = Boolean.valueOf(this.properties_.getProperty("eclipseConsole", "true"));
                boolean bl4 = Boolean.valueOf(this.properties_.getProperty("console", "false"));
                String string4 = this.properties_.getProperty("directory", this.loggingDirectory_.getCanonicalPath());
                this.loggingDirectory_ = new Directory(string4);
                this.loggingDirectory_.makeDirectories();
                LoggingConfigurator loggingConfigurator = (LoggingConfigurator)this._injector.getInstance(LoggingConfigurator.class);
                loggingConfigurator.setLogDirectory(this.loggingDirectory_);
                loggingConfigurator.setPrefix(string2);
                loggingConfigurator.setDefaultLayout((Layout)new PatternLayout(string3));
                loggingConfigurator.setRootLevel(Level.fromString(string));
                if (bl3) {
                    loggingConfigurator.addEclipseConsoleAppender();
                }
                if (bl4) {
                    loggingConfigurator.addConsoleAppender();
                }
                if (bl2) {
                    loggingConfigurator.addStandardHouseKeepingAppenders();
                }
            }
            for (String string5 : this.properties_.keySet()) {
                if (!string5.startsWith("level.")) continue;
                string = string5.substring("level.".length());
                Level level = Level.fromString(this.properties_.getProperty(string5));
                LoggerHelper.getLogger(string).setLevel(level);
            }
        }
    }
}

