/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Enumeration;
import net.model3.guice.bootstrap.ApplicationName;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.logging.HouseKeeper;
import net.model3.logging.HouseKeeperManager;
import net.model3.logging.Level;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.logging.LoggedOutputStream;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.log4j.EclipseConsoleAppender;
import net.model3.logging.log4j.HouseKeepingFileAppender;
import net.model3.logging.log4j.SmtpAppender;
import net.model3.net.SmtpConfig;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.RootLogger;

@Singleton
public class LoggingConfigurator {
    public static final String DEFAULT_PATTERN_LAYOUT = "%d{ABSOLUTE} | %t | %x | %-5p | %c | %m%n";
    @Inject
    ConfigurationDirectory _configurationDirectory;
    private Directory logDirectory_;
    private Directory archiveDirectory_;
    private String prefix_;
    private Layout defaultLayout_;
    private Level defaultLevel_ = Level.TRACE;
    private LoggerRepository loggerRepository_ = LogManager.getLoggerRepository();
    @Inject
    HouseKeeperManager _houseKeeperManager;

    @Inject
    private LoggingConfigurator() {
    }

    public void setRootLoggerLevel(Level level) {
        LoggerHelper.getLogger().getRoot().setLevel(level);
    }

    public void setLoggerLevel(Class clazz, Level level) {
        LoggerHelper.getLogger(clazz).setLevel(level);
    }

    public void setLoggerLevel(String string, Level level) {
        LoggerHelper.getLogger(string).setLevel(level);
    }

    public HouseKeepingFileAppender addDetailAppender() {
        return this.addHouseKeepingFileAppender(null, "detail", ".details");
    }

    public void addEmailErrorsAppender(String string, SmtpConfig smtpConfig, String string2, String string3, String string4) {
        SmtpAppender smtpAppender = new SmtpAppender();
        smtpAppender.setBlackoutDuration("5 minutes");
        smtpAppender.setBufferSize(1024);
        smtpAppender.setLayout(this.getDefaultLayout());
        smtpAppender.setSmtpConfig(smtpConfig);
        smtpAppender.setFrom(string2);
        smtpAppender.setTo(string3);
        smtpAppender.setSubject(string4);
        this.addAppender((Appender)smtpAppender, true);
    }

    public HouseKeepingFileAppender addErrorAppender() {
        return this.addHouseKeepingFileAppender(Level.WARN, "error", ".errors");
    }

    public HouseKeepingFileAppender addHouseKeepingFileAppender(Level level, String string, String string2) {
        return this.addHouseKeepingFileAppender(null, level, string, string2);
    }

    public HouseKeepingFileAppender addHouseKeepingFileAppender(Log log, Level level, String string, String string2) {
        HouseKeepingFileAppender houseKeepingFileAppender = new HouseKeepingFileAppender(new HouseKeeper(this.getHouseKeeperManager()));
        houseKeepingFileAppender.setArchiveDirectory(this.getArchiveDirectory().getCanonicalPath());
        houseKeepingFileAppender.setName(string);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefix_ != null) {
            stringBuilder.append(this.prefix_ + "-");
        }
        stringBuilder.append(string + "-");
        houseKeepingFileAppender.setFilenamePrefix(this.getLogDirectory().getCanonicalPath() + "/" + stringBuilder);
        if (!string2.startsWith(".")) {
            string2 = "." + string2;
        }
        houseKeepingFileAppender.setFilenameSuffix(string2);
        houseKeepingFileAppender.setDaysToKeep(30);
        houseKeepingFileAppender.setLayout(this.getDefaultLayout());
        if (level != null) {
            houseKeepingFileAppender.setThreshold((Priority)((org.apache.log4j.Level)level.getDelegate()));
        }
        this.addAppender(log, (Appender)houseKeepingFileAppender, true);
        return houseKeepingFileAppender;
    }

    public void removeAppender(String string) {
        RootLogger rootLogger = (RootLogger)LogHelper.getFactory().getRootLog().getDelegate();
        rootLogger.removeAppender(string);
    }

    public void removeAppender(Appender appender) {
        RootLogger rootLogger = (RootLogger)LogHelper.getFactory().getRootLog().getDelegate();
        rootLogger.removeAppender(appender);
    }

    public void addAppender(Appender appender, boolean bl) {
        this.addAppender(null, appender, bl);
    }

    public void addAppender(Log log, Appender appender, boolean bl) {
        AppenderSkeleton appenderSkeleton;
        if (appender instanceof AppenderSkeleton && (appenderSkeleton = (AppenderSkeleton)appender).getThreshold() == null) {
            appenderSkeleton.setThreshold((Priority)((org.apache.log4j.Level)this.getDefaultThreshhold().getDelegate()));
        }
        if (bl) {
            if (appender.getLayout() == null) {
                appender.setLayout(this.getDefaultLayout());
            }
            if (appender instanceof OptionHandler) {
                ((OptionHandler)appender).activateOptions();
            }
        }
        if (log == null) {
            log = LoggerHelper.getLogger().getRoot();
        }
        appenderSkeleton = (org.apache.log4j.Logger)log.getDelegate();
        appenderSkeleton.removeAppender(appender.getName());
        appenderSkeleton.addAppender(appender);
    }

    public Directory getConfigurationDirectory() {
        if (this._configurationDirectory == null) {
            this._configurationDirectory = new ConfigurationDirectory(new Directory("."));
        }
        return (Directory)this._configurationDirectory.get();
    }

    public Directory getLogDirectory() {
        if (this.logDirectory_ == null) {
            this.logDirectory_ = new Directory(this.getConfigurationDirectory(), "./logs/");
        }
        if (!this.logDirectory_.exists()) {
            this.logDirectory_.makeDirectories();
        }
        return this.logDirectory_;
    }

    public Directory getArchiveDirectory() {
        if (this.archiveDirectory_ == null) {
            this.archiveDirectory_ = new Directory(this.getLogDirectory(), "archives");
        }
        if (!this.archiveDirectory_.exists()) {
            this.archiveDirectory_.makeDirectories();
        }
        return this.archiveDirectory_;
    }

    public Layout getDefaultLayout() {
        if (this.defaultLayout_ == null) {
            PatternLayout patternLayout = new PatternLayout();
            patternLayout.setConversionPattern(DEFAULT_PATTERN_LAYOUT);
            patternLayout.activateOptions();
            this.defaultLayout_ = patternLayout;
        }
        return this.defaultLayout_;
    }

    public void setDefaultLayout(Layout layout) {
        this.defaultLayout_ = layout;
    }

    public String getPrefix() {
        return this.prefix_;
    }

    public void setPrefix(String string) {
        this.prefix_ = string;
    }

    @Inject
    public void setPrefix(ApplicationName applicationName) {
        this.prefix_ = (String)applicationName.get();
    }

    public void setArchiveDirectory(Directory directory) {
        this.archiveDirectory_ = directory;
    }

    public void setLogDirectory(Directory directory) {
        this.logDirectory_ = directory;
    }

    private org.apache.log4j.Logger getRootLogger() {
        return (org.apache.log4j.Logger)LogHelper.getFactory().getRootLog().getDelegate();
    }

    public EclipseConsoleAppender addEclipseConsoleAppender() {
        EclipseConsoleAppender eclipseConsoleAppender = new EclipseConsoleAppender();
        eclipseConsoleAppender.setThreshold((Priority)((org.apache.log4j.Level)this.defaultLevel_.getDelegate()));
        eclipseConsoleAppender.setLayout(this.defaultLayout_);
        this.addAppender((Appender)eclipseConsoleAppender, true);
        return eclipseConsoleAppender;
    }

    public void addStandardFileAppenders() {
        this.addFileAppender("details", Level.TRACE, new File(this.getLogDirectory(), this.getPrefix() + "-" + File.getFileSystemCompatibleTimestamp() + ".details"));
        this.addFileAppender("errors", Level.WARN, new File(this.getLogDirectory(), this.getPrefix() + "-" + File.getFileSystemCompatibleTimestamp() + ".errors"));
    }

    public HouseKeepingFileAppender[] addStandardHouseKeepingAppenders() {
        HouseKeepingFileAppender[] houseKeepingFileAppenderArray = new HouseKeepingFileAppender[]{this.addDetailAppender(), this.addErrorAppender()};
        return houseKeepingFileAppenderArray;
    }

    public ConsoleAppender addConsoleAppender(String string, boolean bl) {
        String string2 = bl ? "System.out" : "System.err";
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setTarget(string2);
        consoleAppender.setName(string);
        this.addAppender((Appender)consoleAppender, true);
        return consoleAppender;
    }

    public FileAppender addFileAppender(String string, Level level, File file) {
        if (level == null) {
            level = Level.TRACE;
        }
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(file.getCanonicalPath());
        fileAppender.setImmediateFlush(true);
        fileAppender.setThreshold((Priority)((org.apache.log4j.Level)level.getDelegate()));
        this.addAppender((Appender)fileAppender, true);
        return fileAppender;
    }

    public Level getDefaultThreshhold() {
        return this.defaultLevel_;
    }

    public void addConsoleAppender() {
        this.addConsoleAppender("stdout", true);
    }

    public void setDefaultLevel(Level level) {
        this.defaultLevel_ = level;
    }

    public void setRootLevel(Level level) {
        ((org.apache.log4j.Logger)LogHelper.getFactory().getRootLog().getDelegate()).setLevel((org.apache.log4j.Level)level.getDelegate());
    }

    public void basicConfig() {
        this.addConsoleAppender();
        this.setRootLoggerLevel(this.defaultLevel_);
    }

    public LoggerRepository getLoggerRepository() {
        return this.loggerRepository_;
    }

    public void setLoggerRepository(LoggerRepository loggerRepository) {
        this.loggerRepository_ = loggerRepository;
    }

    public void initDefaultConfig(String string) {
        this.setPrefix(string);
        this.addStandardHouseKeepingAppenders();
        this.addEclipseConsoleAppender();
    }

    public void noLogging() {
        this.getRootLogger().setLevel(org.apache.log4j.Level.OFF);
    }

    public void addNoSelectOnePlusOneFilter() {
        NoSelectOnePlusOneFilter noSelectOnePlusOneFilter = new NoSelectOnePlusOneFilter();
        Enumeration enumeration = this.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Filter filter;
            Appender appender = (Appender)enumeration.nextElement();
            for (filter = appender.getFilter(); filter != null; filter = filter.getNext()) {
                if (!(filter instanceof NoSelectOnePlusOneFilter)) continue;
                filter = null;
                break;
            }
            if (filter != null) continue;
            appender.addFilter((Filter)noSelectOnePlusOneFilter);
        }
    }

    public void doDefaultStandaloneAppConfig() {
        this.addStandardHouseKeepingAppenders();
        this.addUncaughtExceptionHandler();
        this.overrideSystemErr();
        this.overrideSystemOut();
    }

    public void addUncaughtExceptionHandler() {
        final Logger logger = LoggerHelper.getLogger("UncaughtExceptionHandler");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                logger.error((Object)"uncaught exception from thread {}", (Object)thread.getId(), (Object)throwable);
            }
        });
    }

    public void overrideSystemErrAndOut() {
        this.overrideSystemErr();
        this.overrideSystemOut();
    }

    public void overrideSystemOut() {
        LoggedOutputStream loggedOutputStream = new LoggedOutputStream(Level.INFO, LoggerHelper.getLogger("stdout"));
        System.setOut(loggedOutputStream);
    }

    public void overrideSystemErr() {
        LoggedOutputStream loggedOutputStream = new LoggedOutputStream(Level.WARN, LoggerHelper.getLogger("stderr"));
        System.setErr(loggedOutputStream);
    }

    public HouseKeeperManager getHouseKeeperManager() {
        return this._houseKeeperManager;
    }

    class NoSelectOnePlusOneFilter
    extends Filter {
        NoSelectOnePlusOneFilter() {
        }

        public int decide(LoggingEvent loggingEvent) {
            String string;
            if (loggingEvent.getLoggerName().startsWith("jdbc.") && (string = (String)loggingEvent.getMessage()).contains("select 1+1")) {
                return -1;
            }
            return 1;
        }
    }
}

