/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import java.io.PrintStream;
import net.model3.io.NullOutputStream;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class LoggedOutputStream
extends PrintStream {
    protected static final String LINE_SEPERATOR = System.getProperty("line.separator");
    protected boolean closed_ = false;
    protected byte[] buffer_;
    protected final byte[] originalBuffer_;
    protected int bufferIndex_;
    private int bufferLength_;
    public static final int DEFAULT_BUFFER_LENGTH = 2048;
    protected Logger logger_;
    protected Level level_;

    public LoggedOutputStream(Level level, Logger logger) throws IllegalArgumentException {
        super(new NullOutputStream());
        if (logger == null) {
            throw new IllegalArgumentException("log == null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level == null");
        }
        this.level_ = level;
        this.logger_ = logger;
        this.bufferLength_ = 2048;
        this.buffer_ = new byte[2048];
        this.originalBuffer_ = this.buffer_;
        this.bufferIndex_ = 0;
    }

    public LoggedOutputStream(Level level, String string) throws IllegalArgumentException {
        this(level, LoggerHelper.getLogger(string));
    }

    @Override
    public void close() {
        this.flush();
        this.closed_ = true;
    }

    @Override
    public void write(int n) {
        if (this.closed_) {
            throw new RuntimeException("The stream has been closed.");
        }
        if (n == 0) {
            return;
        }
        if (this.bufferIndex_ == this.bufferLength_) {
            int n2 = this.bufferLength_ * 2;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer_, 0, byArray, 0, this.bufferLength_);
            this.buffer_ = byArray;
            this.bufferLength_ = n2;
        }
        if (n == 10) {
            this.flush();
        } else {
            this.buffer_[this.bufferIndex_] = (byte)n;
            ++this.bufferIndex_;
        }
    }

    @Override
    public void flush() {
        if (this.bufferIndex_ == 0) {
            return;
        }
        if (this.bufferIndex_ == LINE_SEPERATOR.length() && (char)this.buffer_[0] == LINE_SEPERATOR.charAt(0) && (this.bufferIndex_ == 1 || this.bufferIndex_ == 2 && (char)this.buffer_[1] == LINE_SEPERATOR.charAt(1))) {
            this.reset();
            return;
        }
        byte[] byArray = new byte[this.bufferIndex_];
        System.arraycopy(this.buffer_, 0, byArray, 0, this.bufferIndex_);
        this.logger_.log(this.level_, new String(byArray));
        this.reset();
    }

    private void reset() {
        this.bufferIndex_ = 0;
        this.buffer_ = this.originalBuffer_;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        byArray.toString();
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[i + n]);
        }
    }
}

