/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.model3.logging.Level;
import net.model3.logging.Log;
import net.model3.logging.dyna.LogFactoryDyna;
import net.model3.logging.jdk.LogFactoryJDK;
import net.model3.logging.log4j.LogFactoryLog4j;
import net.model3.logging.simple.LogFactorySimple;

public abstract class LogFactory {
    private static LogFactory instance_;
    private Log _rootLog;
    private final Map<String, Log> logMap_ = new Hashtable<String, Log>();

    public static LogFactory getInstance() {
        if (instance_ == null) {
            LogFactory.initInstance();
        }
        return instance_;
    }

    private static void initInstance() {
        String string = System.getProperty("model3.logFactory", "");
        LogFactory logFactory = string.equalsIgnoreCase("log4j") ? new LogFactoryLog4j() : (string.equalsIgnoreCase("dyna") ? new LogFactoryDyna() : (string.equalsIgnoreCase("simple") ? new LogFactorySimple() : (string.equalsIgnoreCase("jdk") ? new LogFactoryJDK() : (LogFactory.isLog4jOnTheClasspath() ? new LogFactoryLog4j() : new LogFactoryJDK()))));
        LogFactory.setInstance(logFactory);
    }

    public static void setInstance(LogFactory logFactory) {
        Level.setDelegates(null);
        instance_ = logFactory;
    }

    protected abstract Log createLogImpl(String var1);

    protected abstract Log initRootLogger();

    protected abstract Map<Level, Object> getLevelToDelegatesMap();

    public Log getRootLog() {
        if (this._rootLog == null) {
            this._rootLog = this.initRootLogger();
        }
        return this._rootLog;
    }

    public Map<Object, Level> getDelegatesToLevelMap() {
        Map<Level, Object> map = this.getLevelToDelegatesMap();
        HashMap<Object, Level> hashMap = new HashMap<Object, Level>();
        for (Level level : map.keySet()) {
            Object object = map.get((Object)level);
            hashMap.put(object, level);
        }
        return hashMap;
    }

    public Log getLog() {
        return this.getLog(2);
    }

    protected void addLog(Log log) {
        this.logMap_.put(log.getName(), log);
    }

    public Log getLog(int n) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        return this.getLog(stackTraceElementArray[n].getClassName());
    }

    public Log getLog(Class clazz) {
        return this.getLog(clazz.getName());
    }

    public Log getLog(String string) {
        Log log = this.logMap_.get(string);
        if (log == null) {
            log = this.createLogImpl(string);
            this.logMap_.put(string, log);
        }
        return log;
    }

    public void shutdown() {
    }

    private static boolean isLog4jOnTheClasspath() {
        try {
            org.apache.log4j.Level.class.toString();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Map<String, Log> getLogMap() {
        return this.logMap_;
    }
}

