/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import java.util.Deque;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Level;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public abstract class LogCapturingTransaction {
    Appender _appender = new AppenderSkeleton(){

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent loggingEvent) {
            LogCapturingTransaction.this._events.add(loggingEvent);
        }
    };
    Deque<LoggingEvent> _events = new LinkedBlockingDeque<LoggingEvent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = UUID.randomUUID().toString();
        this._appender.setName(string);
        Logger logger = (Logger)LoggerHelper.getRootLogger().getDelegate();
        try {
            logger.addAppender(this._appender);
            this.runImpl();
        }
        catch (Exception exception) {
            ExceptionPropagator.throwUnchecked(exception);
        }
        finally {
            logger.removeAppender(this._appender);
        }
    }

    protected abstract void runImpl() throws Exception;

    public String getEventsAsString() {
        return this.getEventsAsString(null);
    }

    public Level getMostSevereLevel() {
        org.apache.log4j.Level level = org.apache.log4j.Level.ALL;
        for (LoggingEvent loggingEvent : this._events) {
            if (!loggingEvent.getLevel().isGreaterOrEqual((Priority)level)) continue;
            level = loggingEvent.getLevel();
        }
        for (Level level2 : Level.values()) {
            if (!level2.getDelegate().equals(level)) continue;
            return level2;
        }
        return Level.FATAL;
    }

    public String getEventsAsString(Layout layout) {
        if (layout == null) {
            layout = new SimpleLoggingConfigurator().getDefaultLayout();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = layout.getHeader();
        if (string != null) {
            stringBuilder.append(string);
        }
        for (LoggingEvent loggingEvent : this._events) {
            String[] stringArray;
            stringBuilder.append(layout.format(loggingEvent));
            if (!layout.ignoresThrowable() || (stringArray = loggingEvent.getThrowableStrRep()) == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append("\n");
            }
        }
        string = layout.getFooter();
        if (string != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

