/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import java.util.Map;
import net.model3.logging.LogFactory;

public enum Level {
    ALL,
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR,
    FATAL,
    OFF;

    private transient Object levelDelegate_;

    public Object getDelegate() {
        if (this.levelDelegate_ == null) {
            Level.setDelegates(LogFactory.getInstance().getLevelToDelegatesMap());
        }
        return this.levelDelegate_;
    }

    public void setDelegate(Object object) {
        this.levelDelegate_ = object;
    }

    static void setDelegates(Map<Level, Object> map) {
        if (map == null || map.size() == 0) {
            for (Level level : Level.values()) {
                level.setDelegate(null);
            }
        } else {
            for (Level level : Level.values()) {
                level.setDelegate(map.get((Object)level));
            }
        }
    }

    public static Level fromString(String string) {
        for (Level level : Level.values()) {
            if (!level.name().equalsIgnoreCase(string)) continue;
            return level;
        }
        return null;
    }
}

