/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.HouseKeeper;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class HouseKeeperManager {
    private static Logger logger = LoggerHelper.getLogger();
    private final Set<WeakReference<HouseKeeper>> houseKeepers_ = Collections.synchronizedSet(new HashSet());
    @Inject
    ThreadScheduler _threadScheduler;
    boolean _houseKeepingScheduled = false;

    @Inject
    private HouseKeeperManager() {
    }

    private void scheduleMidnightHouseKeeping() {
        this._houseKeepingScheduled = true;
        GregorianCalendar gregorianCalendar = this.getTomorrowsDate();
        ((Calendar)gregorianCalendar).add(13, 1);
        TimeDuration timeDuration = new TimeDuration(gregorianCalendar.getTimeInMillis() - System.currentTimeMillis());
        logger.debug((Object)"scheduled midnight house keeping {} which is a delay of {}", (Object)gregorianCalendar.getTime(), (Object)timeDuration);
        this._threadScheduler.schedule("log-housekeeper", timeDuration, new Runnable(){

            @Override
            public void run() {
                try {
                    HouseKeeperManager.this.scheduleMidnightHouseKeeping();
                }
                catch (Exception exception) {
                    logger.error((Object)"unable to schedule midnight house keeping", (Object)exception);
                }
                HouseKeeperManager.this.cleanupHouseKeepers(null);
                for (WeakReference weakReference : HouseKeeperManager.this.houseKeepers_) {
                    HouseKeeper houseKeeper = (HouseKeeper)weakReference.get();
                    if (houseKeeper == null) continue;
                    houseKeeper.rollover();
                }
            }
        });
    }

    void cleanupHouseKeepers(HouseKeeper houseKeeper) {
        HashSet<WeakReference<HouseKeeper>> hashSet = new HashSet<WeakReference<HouseKeeper>>();
        for (WeakReference<HouseKeeper> weakReference : this.houseKeepers_) {
            HouseKeeper houseKeeper2 = (HouseKeeper)weakReference.get();
            if (houseKeeper2 != null && houseKeeper2 != houseKeeper) continue;
            hashSet.add(weakReference);
        }
        this.houseKeepers_.removeAll(hashSet);
    }

    GregorianCalendar getTomorrowsDate() {
        GregorianCalendar gregorianCalendar = this.getTodaysDate();
        gregorianCalendar.add(5, 1);
        Date date = gregorianCalendar.getTime();
        return gregorianCalendar;
    }

    GregorianCalendar getTodaysDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n, n2, n3);
        return gregorianCalendar2;
    }

    void moveFile(File file, File file2) {
        boolean bl;
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (bl = file.renameTo(file2)) {
            return;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[10000];
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        file.delete();
    }

    public void add(HouseKeeper houseKeeper) {
        this.houseKeepers_.add(new WeakReference<HouseKeeper>(houseKeeper));
        if (!this._houseKeepingScheduled) {
            this._houseKeepingScheduled = true;
            this.scheduleMidnightHouseKeeping();
        }
    }

    public void remove(HouseKeeper houseKeeper) {
        this.cleanupHouseKeepers(houseKeeper);
    }
}

