/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.GZIPOutputStream;
import net.model3.io.NullOutputStream;
import net.model3.io.Pipe;
import net.model3.lang.ByteSize;
import net.model3.lang.TimeDuration;
import net.model3.logging.DummyLog;
import net.model3.logging.HouseKeeperManager;
import net.model3.logging.LogFactory;
import net.model3.logging.Logger;

public class HouseKeeper {
    private static Logger logger = new DummyLog();
    private DateFormat datePattern_ = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private String filenamePrefix_ = "";
    private String filenameSuffix_ = ".log";
    private File archiveDirectory_;
    private TimeDuration keepFor_ = new TimeDuration("10 days");
    private OutputStream currentOutputStream_ = new NullOutputStream();
    boolean _gzipArchives = true;
    int _rollOverByteCount = Integer.MAX_VALUE;
    int _byteCount = 0;
    private OutputStream _outputStreamWrapper = new OutputStream(){

        @Override
        public void write(int n) throws IOException {
            HouseKeeper.this.currentOutputStream_.write(n);
            ++HouseKeeper.this._byteCount;
        }

        @Override
        public void flush() throws IOException {
            HouseKeeper.this.currentOutputStream_.flush();
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            HouseKeeper.this.currentOutputStream_.write(byArray, n, n2);
            HouseKeeper.this._byteCount += n2;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }
    };
    private File file_;
    private long nextRollover_ = Long.MIN_VALUE;
    private HouseKeeperManager _manager;

    @Inject
    public HouseKeeper(HouseKeeperManager houseKeeperManager) {
        this._manager = houseKeeperManager;
        this._manager.add(this);
    }

    public HouseKeeper() {
    }

    public void checkForHouseKeeping() {
        long l = System.currentTimeMillis();
        if (this.isRolloverNeeded()) {
            this.rollover();
        }
    }

    boolean isRolloverNeeded() {
        return System.currentTimeMillis() >= this.nextRollover_ || this._byteCount > this._rollOverByteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollover() {
        if (!this.isRolloverNeeded()) {
            return;
        }
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (!this.isRolloverNeeded()) {
                return;
            }
            String string = this.datePattern_.format(new Date());
            String string2 = this.filenamePrefix_ + string + this.filenameSuffix_;
            try {
                this.file_ = new File(string2);
                this.file_.getParentFile().mkdirs();
                this.setCurrentStream(new FileOutputStream(this.file_));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nextRollover_ = HouseKeeper.getTomorrowsDate().getTimeInMillis();
            this.submitHouseKeeping();
        }
    }

    private void resetNextRollover() {
        GregorianCalendar gregorianCalendar = HouseKeeper.getTomorrowsDate();
        this.nextRollover_ = gregorianCalendar.getTimeInMillis();
    }

    private static GregorianCalendar getTomorrowsDate() {
        GregorianCalendar gregorianCalendar = HouseKeeper.getTodaysDate();
        gregorianCalendar.add(5, 1);
        Date date = gregorianCalendar.getTime();
        return gregorianCalendar;
    }

    private static GregorianCalendar getTodaysDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n, n2, n3);
        return gregorianCalendar2;
    }

    protected void setCurrentStream(OutputStream outputStream) {
        OutputStream outputStream2 = this.currentOutputStream_;
        this.currentOutputStream_ = outputStream;
        this._byteCount = 0;
        try {
            outputStream2.close();
        }
        catch (IOException iOException) {
            logger.error((Object)"Could not close {}", (Object)outputStream, (Object)iOException);
        }
    }

    public void setDaysToKeep(int n) {
        this.keepFor_ = new TimeDuration("" + n + " days");
    }

    public void setKeepFor(String string) {
        this.keepFor_ = new TimeDuration(string);
    }

    public void setFilenamePrefix(String string) {
        File file = new File(string.trim());
        this.filenamePrefix_ = file.getAbsolutePath();
    }

    public void setFilenameSuffix(String string) {
        this.filenameSuffix_ = string.trim();
    }

    public void setDatePattern(String string) {
        String string2 = string.trim();
        this.datePattern_ = new SimpleDateFormat(string);
    }

    private void submitHouseKeeping() {
        this._manager._threadScheduler.submit("log-housekeeping", new Runnable(){

            @Override
            public void run() {
                HouseKeeper.this.doHouseKeeping();
            }
        });
    }

    void doHouseKeeping() {
        this.doHouseKeeping(this.file_);
    }

    void doHouseKeeping(File file) {
        File[] fileArray;
        Object object;
        logger = LogFactory.getInstance().getLog();
        logger.debug((Object)"doing housekeeping for {}", (Object)this.filenamePrefix_);
        String string = new File(this.filenamePrefix_).getName().toLowerCase();
        String string2 = this.filenameSuffix_.toLowerCase();
        File[] fileArray2 = file.getParentFile().listFiles();
        for (File fileArray3 : fileArray2) {
            File[] fileArray4;
            if (fileArray3.isDirectory() || fileArray3.equals(file) || !(fileArray4 = fileArray3.getName().toLowerCase()).startsWith(string) || !fileArray4.endsWith(string2)) continue;
            if (fileArray3.length() == 0L) {
                try {
                    logger.debug((Object)"deleting log file it has no data {}", (Object)fileArray3.getAbsolutePath());
                    fileArray3.delete();
                }
                catch (Exception exception) {
                    logger.info((Object)"unable to delete log file {}", (Object)fileArray3.getAbsolutePath(), (Object)exception);
                }
                continue;
            }
            try {
                File exception = new File(this.getArchiveDirectory(), fileArray3.getName());
                logger.debug((Object)"moving log file {}  to  {}", (Object)fileArray3.getAbsolutePath(), (Object)exception.getAbsolutePath());
                HouseKeeper.moveFile(fileArray3, exception);
                if (!this._gzipArchives) continue;
                File file2 = new File(this.getArchiveDirectory(), fileArray3.getName() + ".gz");
                FileInputStream fileInputStream = new FileInputStream(exception);
                object = new GZIPOutputStream(new FileOutputStream(file2));
                new Pipe(fileInputStream, (OutputStream)object).run();
                exception.delete();
            }
            catch (Exception exception) {
                logger.info((Object)"unable to move log file {}", (Object)fileArray3.getAbsolutePath(), (Object)exception);
            }
        }
        if (this.keepFor_.inMilliseconds() < 0L) {
            return;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(5, (int)(-this.keepFor_.inDays()));
        long l = gregorianCalendar.getTimeInMillis();
        for (File file3 : fileArray = this.getArchiveDirectory().listFiles()) {
            if (file3.isDirectory() || file3.lastModified() > l || !this.isValidLogFile((String)(object = file3.getName().toLowerCase()), string, string2)) continue;
            if (file3.delete()) {
                logger.debug((Object)("deleted log file " + file3.getAbsolutePath()));
                continue;
            }
            logger.info((Object)("unable to delete log file " + file3.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidLogFile(String string, String string2, String string3) {
        if (string.startsWith(string2) && string.endsWith(string3)) {
            String string4 = string.substring(string2.length(), string.length() - string3.length());
            try {
                DateFormat dateFormat = this.datePattern_;
                synchronized (dateFormat) {
                    this.datePattern_.parse(string4);
                }
                return true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    public void activateOptions() {
        this.rollover();
    }

    public void setArchiveDirectory(String string) {
        this.archiveDirectory_ = new File(string);
    }

    static void moveFile(File file, File file2) {
        boolean bl;
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (bl = file.renameTo(file2)) {
            return;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[10000];
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        file.delete();
    }

    public String getFilenamePrefix() {
        return this.filenamePrefix_;
    }

    public OutputStream getOutputStream() {
        return this._outputStreamWrapper;
    }

    public File getArchiveDirectory() {
        if (this.archiveDirectory_ == null) {
            this.archiveDirectory_ = new File(this.file_.getParentFile(), "archives");
            this.archiveDirectory_.mkdirs();
        }
        return this.archiveDirectory_;
    }

    public void shutdown() {
        try {
            this.currentOutputStream_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._manager.remove(this);
    }

    public void setRollOverByteCount(ByteSize byteSize) {
        this._rollOverByteCount = (int)byteSize.inBytes();
    }

    public void setRollOverByteCount(int n) {
        this._rollOverByteCount = n;
    }

    public int getRollOverByteCount() {
        return this._rollOverByteCount;
    }

    public boolean gzipArchives() {
        return this._gzipArchives;
    }

    public void setGzipArchives(boolean bl) {
        this._gzipArchives = bl;
    }
}

