/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.guice.DependencyInjector;
import net.model3.guice.PropertySource;
import net.model3.guice.bootstrap.ApplicationName;
import net.model3.guice.bootstrap.LogDirectory;
import net.model3.lang.Function0;
import net.model3.lang.Pair;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.newfile.Directory;
import net.model3.util.ProcessManagerHelper;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

@Singleton
public class AutoLoggingConfigurator {
    static final String LogAutoProcessedKey = "log.auto.processed";
    Logger logger = LoggerHelper.getLogger();
    boolean _doDefault = true;
    final PropertySource _propertySource;
    final ApplicationName _applicationName;
    final LogDirectory _logDirectory;
    final SimpleLoggingConfigurator _simpleLoggingConfigurator;
    Map<String, Pair<String, Function0<Void>>> _options = new CaseInsensitiveMapWrapper<Pair<String, Function0<Void>>>(new LinkedHashMap());

    public static boolean isAlreadyConfigured() {
        return DependencyInjector.getInstance(PropertySource.class).has(LogAutoProcessedKey);
    }

    @Inject
    public AutoLoggingConfigurator(PropertySource propertySource, ApplicationName applicationName, LogDirectory logDirectory) {
        this.addOption("console", "standard System.out logging", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doConsole();
                return null;
            }
        });
        this.addOption("eclipse", "standard eclipse logging with warnings and errors in red (aka System.err) everything else in black (System.out)", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doEclipe();
                return null;
            }
        });
        this.addOption("procman", "logging for a process manager app System.out gets everything, System.err gets warnings and errors", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doProcman();
                return null;
            }
        });
        this.addOption("stdfile", "creates the standard details and errors log files, override the file prefix with log.prefix and location with lod.dir", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doStdFile();
                return null;
            }
        });
        this.addOption("usage", "shows this message to stdout", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doUsage();
                return null;
            }
        });
        this.addOption("usage.stderr", "shows this message to stderr", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doUsageStderr();
                return null;
            }
        });
        this.addOption("no-default", "turn off default config, all config must be explicit", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doNoDefault();
                return null;
            }
        });
        this.addOption("override-system-err", "override System.err to log to a logger", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doOverrideSystemErr();
                return null;
            }
        });
        this.addOption("override-system-out", "override System.out to log to a logger", new Function0<Void>(){

            @Override
            public Void apply() {
                AutoLoggingConfigurator.this.doOverrideSystemOut();
                return null;
            }
        });
        this._propertySource = propertySource;
        this._applicationName = applicationName;
        this._logDirectory = logDirectory;
        this._simpleLoggingConfigurator = new SimpleLoggingConfigurator(this.getPrefix());
        this._simpleLoggingConfigurator.setLogsDirectory((Directory)this._logDirectory.get());
    }

    String getPrefix() {
        return this._propertySource.get("log.prefix", (String)this._applicationName.get());
    }

    public void addOption(String string, String string2, Function0<Void> function0) {
        this._options.put("log." + string, Pair.create(string2, function0));
    }

    public void doOverrideSystemOut() {
        this.logger.debug((Object)"doOverrideSystemOut()");
        this._simpleLoggingConfigurator.overrideSystemOut();
    }

    public void doOverrideSystemErr() {
        this.logger.debug((Object)"doOverrideSystemErr()");
        this._simpleLoggingConfigurator.overrideSystemErr();
    }

    public void doConsole() {
        this.logger.debug((Object)"doConsole()");
        this._simpleLoggingConfigurator.addConsoleAppender();
    }

    public void doEclipe() {
        this.logger.debug((Object)"doEclipe()");
        this._simpleLoggingConfigurator.addEclipseConsoleAppender();
    }

    public void doProcman() {
        this.logger.debug((Object)"doProcman()");
        ConsoleAppender consoleAppender = this._simpleLoggingConfigurator.addConsoleAppender();
        ConsoleAppender consoleAppender2 = this._simpleLoggingConfigurator.addConsoleAppender("stderr", false);
        consoleAppender2.setThreshold((Priority)Level.WARN);
    }

    public void doUsageStderr() {
        this.logger.debug((Object)"doUsageStderr()");
        this.doUsage(System.err);
    }

    public void doUsage() {
        this.logger.debug((Object)"doUsage()");
        this.doUsage(System.out);
    }

    public void doUsage(PrintStream printStream) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("logging config options, set via setting the system property");
        for (String object : this._options.keySet()) {
            Pair<String, Function0<Void>> pair = this._options.get(object);
            printWriter.println("   " + StringX.padRight(object, 25) + " - " + pair.getLeft());
        }
        printWriter.println();
        printWriter.println("   log.dir=dir        - set the directory to use for any file based loggers");
        printWriter.println("   log.prefix=appname - prefix to use for log filenames");
        printWriter.close();
        String string = stringWriter.toString();
        printStream.println(string);
        try {
            FileWriter exception = new FileWriter("log-usage.txt");
            exception.write(string);
            exception.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doNoDefault() {
        this.logger.debug((Object)"doNoDefault()");
        this._doDefault = false;
    }

    public void doStdFile() {
        this.logger.debug((Object)"doStdFile()");
        this._simpleLoggingConfigurator.addStandardFileAppenders();
    }

    public void doDefault() {
        this.logger.debug((Object)"doDefault()");
        if (ProcessManagerHelper.isRunningInProcessManager()) {
            this.doProcman();
        }
    }

    public void apply() {
        this.apply(null);
    }

    public void apply(Function0<Void> function0) {
        if (!this._propertySource.has(LogAutoProcessedKey)) {
            this._propertySource.set(LogAutoProcessedKey, "true");
            if (function0 == null) {
                function0 = new Function0<Void>(){

                    @Override
                    public Void apply() {
                        AutoLoggingConfigurator.this.doDefault();
                        return null;
                    }
                };
            }
            for (String string : this._options.keySet()) {
                String string2 = System.getProperty(string);
                if (string2 == null) continue;
                this.logger.debug((Object)("configuring " + string));
                this._options.get(string).getRight().apply();
            }
            if (this._doDefault) {
                this.logger.debug((Object)"running default config");
                function0.apply();
            }
        }
    }
}

