/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import net.model3.lang.ExceptionPropagator;
import net.model3.logging.HouseKeeper;
import net.model3.logging.Level;
import net.model3.logging.LoggedOutputStream;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.log4j.EclipseConsoleAppender;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.OptionHandler;

public abstract class AbstractLoggingConfigurator {
    public static final String DEFAULT_PATTERN_LAYOUT = "%d{ABSOLUTE} | %t | %x | %-5p | %c | %m%n";
    Directory _logsDirectory;
    Directory _archivesDirectory;
    String _prefix = null;
    Level _defaultLevel = Level.TRACE;
    Layout _defaultLayout;
    Logger loggerLogger = LoggerHelper.getLogger();

    public AbstractLoggingConfigurator() {
    }

    public AbstractLoggingConfigurator(String string) {
        this._prefix = string;
    }

    public Layout getDefaultLayout() {
        if (this._defaultLayout == null) {
            PatternLayout patternLayout = new PatternLayout();
            patternLayout.setConversionPattern(DEFAULT_PATTERN_LAYOUT);
            patternLayout.activateOptions();
            this._defaultLayout = patternLayout;
        }
        return this._defaultLayout;
    }

    public void setDefaultLayout(Layout layout) {
        this._defaultLayout = layout;
    }

    public Level getDefaultLevel() {
        return this._defaultLevel;
    }

    public void setDefaultLevel(Level level) {
        this._defaultLevel = level;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String string) {
        this._prefix = string;
    }

    public ConsoleAppender addConsoleAppender() {
        return this.addConsoleAppender("stdout", true);
    }

    public ConsoleAppender addConsoleAppender(String string, boolean bl) {
        String string2 = bl ? "System.out" : "System.err";
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setTarget(string2);
        consoleAppender.setName(string);
        this.addAppender((Appender)consoleAppender, true);
        return consoleAppender;
    }

    public void addAppender(Appender appender, boolean bl) {
        this.addAppender(null, appender, bl);
    }

    public void addAppender(Logger logger, Appender appender, boolean bl) {
        AppenderSkeleton appenderSkeleton;
        if (appender instanceof AppenderSkeleton && (appenderSkeleton = (AppenderSkeleton)appender).getThreshold() == null) {
            appenderSkeleton.setThreshold((Priority)((org.apache.log4j.Level)this.getDefaultLevel().getDelegate()));
        }
        if (bl) {
            if (appender.getLayout() == null) {
                appender.setLayout(this.getDefaultLayout());
            }
            if (appender instanceof OptionHandler) {
                ((OptionHandler)appender).activateOptions();
            }
        }
        if (logger == null) {
            logger = LoggerHelper.getLogger().getRoot();
        }
        appenderSkeleton = (org.apache.log4j.Logger)logger.getDelegate();
        appenderSkeleton.removeAppender(appender.getName());
        appenderSkeleton.addAppender(appender);
    }

    public void setLogsDirectory(Directory directory) {
        this._logsDirectory = directory;
    }

    public Directory getArchivesDirectory() {
        if (this._archivesDirectory == null) {
            this._archivesDirectory = new Directory(this.getLogsDirectory(), "archives");
        }
        if (!this._archivesDirectory.exists()) {
            this._archivesDirectory.makeDirectories();
        }
        return this._archivesDirectory;
    }

    public Directory getLogsDirectory() {
        if (this._logsDirectory == null) {
            this._logsDirectory = new Directory("./.logs/");
        }
        if (!this._logsDirectory.exists()) {
            this._logsDirectory.makeDirectories();
        }
        return this._logsDirectory;
    }

    public void addStandardFileAppenders() {
        this.addFileAppender("details", Level.TRACE, new File(this.getLogsDirectory(), this.getPrefix() + "-" + File.getFileSystemCompatibleTimestamp() + ".details"), true);
        this.addFileAppender("errors", Level.WARN, new File(this.getLogsDirectory(), this.getPrefix() + "-" + File.getFileSystemCompatibleTimestamp() + ".errors"), true);
    }

    public void doHouseKeeping(final String string, File file) {
        try {
            HouseKeeper houseKeeper = new HouseKeeper(){
                {
                    this.setFilenamePrefix(AbstractLoggingConfigurator.this.getPrefix());
                    this.setFilenameSuffix(string);
                    this.setKeepFor("7 days");
                    this.setArchiveDirectory(AbstractLoggingConfigurator.this.getArchivesDirectory().getCanonicalPath());
                    AbstractLoggingConfigurator.this.setLogsDirectory(AbstractLoggingConfigurator.this.getLogsDirectory());
                    AbstractLoggingConfigurator.this.setPrefix(AbstractLoggingConfigurator.this.getPrefix());
                }
            };
            houseKeeper.doHouseKeeping(file.asFile());
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public FileAppender addFileAppender(String string, Level level, File file, boolean bl) {
        this.loggerLogger.debug(new Object[]{"adding file appender -- name = {}  file = {}  level = {}  archiveOldLogFiles = {}", string, file, level, bl});
        if (level == null) {
            level = Level.TRACE;
        }
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(file.getCanonicalPath());
        fileAppender.setImmediateFlush(true);
        fileAppender.setThreshold((Priority)((org.apache.log4j.Level)level.getDelegate()));
        this.addAppender((Appender)fileAppender, true);
        if (bl) {
            String string2 = new File(fileAppender.getFile()).getExtension();
            this.doHouseKeeping(string2, file);
        }
        return fileAppender;
    }

    public void overrideSystemErrAndOut() {
        this.overrideSystemErr();
        this.overrideSystemOut();
    }

    public EclipseConsoleAppender addEclipseConsoleAppender() {
        this.loggerLogger.debug((Object)"addEclipseConsoleAppender()");
        EclipseConsoleAppender eclipseConsoleAppender = new EclipseConsoleAppender();
        eclipseConsoleAppender.setThreshold((Priority)((org.apache.log4j.Level)this.getDefaultLevel().getDelegate()));
        eclipseConsoleAppender.setLayout(this.getDefaultLayout());
        this.addAppender((Appender)eclipseConsoleAppender, true);
        return eclipseConsoleAppender;
    }

    public EclipseConsoleAppender addProcmanConsoleAppender() {
        this.addConsoleAppender();
        EclipseConsoleAppender eclipseConsoleAppender = new EclipseConsoleAppender();
        eclipseConsoleAppender.setThreshold((Priority)((org.apache.log4j.Level)this.getDefaultLevel().getDelegate()));
        eclipseConsoleAppender.setLayout(this.getDefaultLayout());
        this.addAppender((Appender)eclipseConsoleAppender, true);
        return eclipseConsoleAppender;
    }

    public void overrideSystemOut() {
        LoggedOutputStream loggedOutputStream = new LoggedOutputStream(Level.INFO, LoggerHelper.getLogger("stdout"));
        System.setOut(loggedOutputStream);
    }

    public void overrideSystemErr() {
        LoggedOutputStream loggedOutputStream = new LoggedOutputStream(Level.WARN, LoggerHelper.getLogger("stderr"));
        System.setErr(loggedOutputStream);
    }

    public void addUncaughtExceptionHandler() {
        final Logger logger = LoggerHelper.getLogger("UncaughtExceptionHandler");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                logger.error((Object)"uncaught exception from thread {}", (Object)thread.getId(), (Object)throwable);
            }
        });
    }
}

