/*
 * Decompiled with CFR 0.152.
 */
package net.model3.logging;

import net.model3.logging.Level;
import net.model3.logging.Log;
import net.model3.logging.LogFactory;
import net.model3.logging.MessageFormatter;

public abstract class AbstractLog
implements Log {
    private LogFactory logFactory_;
    private String name_;

    protected AbstractLog(LogFactory logFactory, String string) {
        this.logFactory_ = logFactory;
        this.name_ = string;
    }

    public LogFactory getLogFactory() {
        return this.logFactory_;
    }

    @Override
    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.logImpl(Level.TRACE, object);
        }
    }

    @Override
    public void trace(Object object, Object object2) {
        if (this.isTraceEnabled()) {
            this.logImpl(Level.TRACE, object, object2);
        }
    }

    @Override
    public void trace(Object object, Object object2, Object object3) {
        if (this.isTraceEnabled()) {
            this.logImpl(Level.TRACE, object, object2, object3);
        }
    }

    @Override
    public void trace(Object object, Object object2, Object object3, Object object4) {
        if (this.isTraceEnabled()) {
            this.logImpl(Level.TRACE, object, object2, object3, object4);
        }
    }

    @Override
    public void trace(Object ... objectArray) {
        if (this.isTraceEnabled()) {
            this.logImpl(Level.TRACE, objectArray);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.logImpl(Level.DEBUG, object);
        }
    }

    @Override
    public void debug(Object object, Object object2) {
        if (this.isDebugEnabled()) {
            this.logImpl(Level.DEBUG, object, object2);
        }
    }

    @Override
    public void debug(Object object, Object object2, Object object3) {
        if (this.isDebugEnabled()) {
            this.logImpl(Level.DEBUG, object, object2, object3);
        }
    }

    @Override
    public void debug(Object object, Object object2, Object object3, Object object4) {
        if (this.isDebugEnabled()) {
            this.logImpl(Level.DEBUG, object, object2, object3, object4);
        }
    }

    @Override
    public void debug(Object ... objectArray) {
        if (this.isDebugEnabled()) {
            this.logImpl(Level.DEBUG, objectArray);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.logImpl(Level.INFO, object);
        }
    }

    @Override
    public void info(Object object, Object object2) {
        if (this.isInfoEnabled()) {
            this.logImpl(Level.INFO, object, object2);
        }
    }

    @Override
    public void info(Object object, Object object2, Object object3) {
        if (this.isInfoEnabled()) {
            this.logImpl(Level.INFO, object, object2, object3);
        }
    }

    @Override
    public void info(Object object, Object object2, Object object3, Object object4) {
        if (this.isInfoEnabled()) {
            this.logImpl(Level.INFO, object, object2, object3, object4);
        }
    }

    @Override
    public void info(Object ... objectArray) {
        if (this.isInfoEnabled()) {
            this.logImpl(Level.INFO, objectArray);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.logImpl(Level.WARN, object);
        }
    }

    @Override
    public void warn(Object object, Object object2) {
        if (this.isWarnEnabled()) {
            this.logImpl(Level.WARN, object, object2);
        }
    }

    @Override
    public void warn(Object object, Object object2, Object object3) {
        if (this.isWarnEnabled()) {
            this.logImpl(Level.WARN, object, object2, object3);
        }
    }

    @Override
    public void warn(Object object, Object object2, Object object3, Object object4) {
        if (this.isWarnEnabled()) {
            this.logImpl(Level.WARN, object, object2, object3, object4);
        }
    }

    @Override
    public void warn(Object ... objectArray) {
        if (this.isWarnEnabled()) {
            this.logImpl(Level.WARN, objectArray);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public void error(Object object) {
        if (this.isErrorEnabled()) {
            this.logImpl(Level.ERROR, object);
        }
    }

    @Override
    public void error(Object object, Object object2) {
        if (this.isErrorEnabled()) {
            this.logImpl(Level.ERROR, object, object2);
        }
    }

    @Override
    public void error(Object object, Object object2, Object object3) {
        if (this.isErrorEnabled()) {
            this.logImpl(Level.ERROR, object, object2, object3);
        }
    }

    @Override
    public void error(Object object, Object object2, Object object3, Object object4) {
        if (this.isErrorEnabled()) {
            this.logImpl(Level.ERROR, object, object2, object3, object4);
        }
    }

    @Override
    public void error(Object ... objectArray) {
        if (this.isErrorEnabled()) {
            this.logImpl(Level.ERROR, objectArray);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.logImpl(Level.FATAL, object);
        }
    }

    @Override
    public void fatal(Object object, Object object2) {
        if (this.isFatalEnabled()) {
            this.logImpl(Level.FATAL, object, object2);
        }
    }

    @Override
    public void fatal(Object object, Object object2, Object object3) {
        if (this.isFatalEnabled()) {
            this.logImpl(Level.FATAL, object, object2, object3);
        }
    }

    @Override
    public void fatal(Object object, Object object2, Object object3, Object object4) {
        if (this.isFatalEnabled()) {
            this.logImpl(Level.FATAL, object, object2, object3, object4);
        }
    }

    @Override
    public void fatal(Object ... objectArray) {
        if (this.isFatalEnabled()) {
            this.logImpl(Level.FATAL, objectArray);
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Level.FATAL);
    }

    protected final void logImpl(Level level, Object ... objectArray) {
        String string;
        if (objectArray == null) {
            objectArray = new Object[]{null};
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray2.length;
        Object object = objectArray2[n - 1];
        Throwable throwable = null;
        boolean bl = false;
        if (object instanceof Throwable) {
            throwable = (Throwable)object;
            if (n == 1) {
                bl = true;
            }
        }
        if (bl) {
            string = "";
        } else {
            Object object2 = objectArray2[0];
            string = object2 instanceof String ? (String)object2 : (object2 == null ? "null" : object2.toString());
            if (objectArray2.length != 1) {
                string = MessageFormatter.format(string, objectArray2, 1);
            }
        }
        this.logImpl(level, string, throwable);
    }

    protected abstract void logImpl(Level var1, String var2, Throwable var3);

    @Override
    public void log(Level level, Object ... objectArray) {
        if (this.isEnabled(level)) {
            this.logImpl(level, objectArray);
        }
    }

    @Override
    public final Log getRoot() {
        return this.getLogFactory().getRootLog();
    }

    @Override
    public String getName() {
        return this.name_;
    }
}

