/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import net.model3.bean.converters.Converter;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.lang.TypeManager;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class TypeManagerFactory<T extends TypeManager> {
    private static final Logger logger = LoggerHelper.getLogger();
    private List<T> _managerList = ListX.create();
    private Map<Class<?>, T> _resolvedManagers = MapX.create();

    public List<T> getManagers() {
        return this._managerList;
    }

    public void addManager(Class<T> clazz) {
        try {
            this.addManager((TypeManager)clazz.newInstance());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.trace((Object)"{} not loaded as a manager because one of the classes it needs/handles is not found in the classpath", (Object)clazz.getName());
        }
        catch (Exception exception) {
            logger.warn((Object)"unable to load manager {}", (Object)clazz.getName(), (Object)exception);
        }
    }

    public void addManager(T t) {
        this._managerList.add(t);
        this._resolvedManagers.clear();
    }

    public T getManager(Class<?> clazz, boolean bl) {
        if (this._resolvedManagers.containsKey(clazz)) {
            return (T)((TypeManager)this._resolvedManagers.get(clazz));
        }
        int n = this._managerList.size();
        for (int i = n - 1; i >= 0; --i) {
            TypeManager typeManager = (TypeManager)this._managerList.get(i);
            if (!typeManager.canManageType(clazz)) continue;
            this._resolvedManagers.put(clazz, typeManager);
            return (T)typeManager;
        }
        if (bl) {
            throw new RuntimeException("cannot find converter for " + clazz);
        }
        return null;
    }

    public T getManager(Object object) {
        return this.getManager(object.getClass());
    }

    public T getManager(Class<?> clazz) {
        return this.getManager(clazz, false);
    }

    public int getManagerPriority(Converter<?> converter) {
        return this._managerList.indexOf(converter);
    }

    public static <T extends TypeManager> TypeManagerFactory<T> create() {
        return new TypeManagerFactory<T>();
    }
}

