/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import net.model3.lang.ByteSize;
import net.model3.lang.Measurement;
import net.model3.lang.ThreadX;
import net.model3.lang.Throughput;

public class TimeDuration
extends Measurement<TimeDuration> {
    private static final long serialVersionUID = -4775754892792481697L;
    private static final Measurement.MetaMeasurement _metaMeasurement = new Measurement.MetaMeasurement("time duration");
    private static final Measurement.MetaMeasurement.Unit Milliseconds = _metaMeasurement.addUnit(1L, "millisecond", "milliseconds", "ms", true, "msec", "msecs");
    private static final Measurement.MetaMeasurement.Unit Seconds = _metaMeasurement.addUnit(1000L, "second", "seconds", "s", true, "sec", "secs");
    private static final Measurement.MetaMeasurement.Unit Hours;
    private static final Measurement.MetaMeasurement.Unit Minutes;
    private static final Measurement.MetaMeasurement.Unit Days;
    private static final Measurement.MetaMeasurement.Unit Weeks;
    private static final Measurement.MetaMeasurement.Unit Months;
    private static final Measurement.MetaMeasurement.Unit Years;
    public static final TimeDuration ZERO;
    public static final TimeDuration MAX;

    public TimeDuration() {
        super(0.0, Minutes);
    }

    public TimeDuration(long l) {
        super(l, Milliseconds);
    }

    public TimeDuration(String string) {
        super(string);
    }

    @Override
    protected Measurement.MetaMeasurement getMetaMeasurement() {
        return _metaMeasurement;
    }

    public long inMilliseconds() {
        return this.getValue();
    }

    public double inSeconds() {
        return this.convertTo(Seconds);
    }

    public double inMinutes() {
        return this.convertTo(Minutes);
    }

    public double inHours() {
        return this.convertTo(Hours);
    }

    public double inDays() {
        return this.convertTo(Days);
    }

    public double inYears() {
        return this.convertTo(Years);
    }

    public void sleep() {
        ThreadX.sleep(this);
    }

    public Throughput asThroughput(ByteSize byteSize) {
        return new Throughput(byteSize, this);
    }

    public static TimeDuration fromMilliseconds(long l) {
        return new TimeDuration(l);
    }

    public static TimeDuration fromMinutes(double d) {
        return TimeDuration.fromMilliseconds((long)(d * 60000.0));
    }

    public static TimeDuration fromSeconds(double d) {
        return TimeDuration.fromMilliseconds((long)(d * 1000.0));
    }

    public static TimeDuration fromDays(double d) {
        return new TimeDuration(d + " days");
    }

    static {
        Minutes = _metaMeasurement.addUnit(60000L, "minute", "minutes", "m", true, "min", "mins");
        Hours = _metaMeasurement.addUnit(3600000L, "hour", "hours", "h", true, new String[0]);
        Days = _metaMeasurement.addUnit(86400000L, "day", "days", "d", true, new String[0]);
        Weeks = _metaMeasurement.addUnit(604800000L, "week", "weeks", "w", true, new String[0]);
        Months = _metaMeasurement.addUnit(2592000000L, "month", "months", "mnth", false, new String[0]);
        Years = _metaMeasurement.addUnit(31557600000L, "year", "years", "y", true, "yr");
        ZERO = new TimeDuration(0L);
        MAX = new TimeDuration(Long.MAX_VALUE);
    }
}

