/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.util.List;
import net.model3.collections.ListX;
import net.model3.lang.SystemX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ThreadX {
    private static final Logger logger = LoggerHelper.getLogger();

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static List<Thread> getAllThreads() {
        ThreadGroup threadGroup = ThreadX.getRootThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount() * 2 + 10];
        List<Thread> list = ListX.create();
        threadGroup.enumerate(threadArray);
        for (Thread thread : threadArray) {
            if (thread == null) continue;
            list.add(thread);
        }
        return list;
    }

    public static void sleep(TimeDuration timeDuration) {
        logger.trace((Object)("sleeping for " + timeDuration));
        ThreadX.sleepImpl(timeDuration.inMilliseconds());
    }

    public static void sleep(long l) {
        logger.trace((Object)("sleeping for " + l + " millseconds"));
        ThreadX.sleepImpl(l);
    }

    private static void sleepImpl(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            logger.debug((Object)"sleep()", (Object)interruptedException);
        }
    }

    public static void logAllThreads() {
        for (Thread thread : ThreadX.getAllThreads()) {
            logger.debug((Object)"Thread  id={}  name={}  loader={}", (Object)thread.getId(), (Object)thread.getName(), (Object)SystemX.identityToString(thread.getContextClassLoader()));
        }
    }
}

