/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.model3.chrono.TimeOnly;
import net.model3.guice.LifeCycleListeners;
import net.model3.guice.LifeCycleManager;
import net.model3.lang.DefaultRunnableWrapper;
import net.model3.lang.RunnableWrapper;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class ThreadScheduler {
    Logger logger = LoggerHelper.getLogger();
    ScheduledExecutorService _delegate;
    RunnableWrapper _runnableWrapper;
    volatile List<Action> _actionsToScheduleOnStart = new ArrayList<Action>();

    public ThreadScheduler(ScheduledExecutorService scheduledExecutorService, boolean bl, RunnableWrapper runnableWrapper) {
        this._delegate = scheduledExecutorService;
        this._runnableWrapper = runnableWrapper;
        if (bl) {
            this.start();
        }
    }

    @Inject
    public ThreadScheduler(LifeCycleManager lifeCycleManager, ScheduledExecutorService scheduledExecutorService, RunnableWrapper runnableWrapper) {
        this._delegate = scheduledExecutorService;
        this._runnableWrapper = runnableWrapper;
        lifeCycleManager.config.add(new LifeCycleListeners.Config(){

            @Override
            public void configComplete() throws Exception {
                ThreadScheduler.this.start();
            }
        });
    }

    public ThreadScheduler(int n, boolean bl) {
        this._delegate = Executors.newScheduledThreadPool(n, new ThreadFactory(){
            AtomicInteger _threadCount = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                ThreadScheduler.this.initializeThread(thread, this._threadCount.incrementAndGet());
                return thread;
            }
        });
        this._runnableWrapper = new DefaultRunnableWrapper();
        if (bl) {
            this.start();
        }
    }

    public Future<?> submit(final String string, final Runnable runnable) {
        return this.process(new Action(){

            @Override
            Future<?> apply() {
                Runnable runnable2 = ThreadScheduler.this.wrapRunnable(string, runnable);
                return ThreadScheduler.this._delegate.submit(runnable2);
            }
        });
    }

    public ScheduledFuture<?> scheduleRepeating(final String string, final TimeDuration timeDuration, final Runnable runnable) {
        return this.processSF(new Action(){

            @Override
            Future<?> apply() {
                return ThreadScheduler.this.scheduleRepeating(string, timeDuration, true, runnable);
            }
        });
    }

    public ScheduledFuture<?> schedule(final String string, final TimeDuration timeDuration, final Runnable runnable) {
        return this.processSF(new Action(){

            @Override
            Future<?> apply() {
                Runnable runnable2 = ThreadScheduler.this.wrapRunnable(string, runnable);
                return ThreadScheduler.this._delegate.schedule(runnable2, timeDuration.inMilliseconds(), TimeUnit.MILLISECONDS);
            }
        });
    }

    public ScheduledFuture<?> scheduleDaily(final String string, final TimeOnly timeOnly, final Runnable runnable) {
        return this.processSF(new Action(){

            @Override
            Future<?> apply() {
                long l;
                Runnable runnable2 = ThreadScheduler.this.wrapRunnable(string, runnable);
                TimeOnly timeOnly2 = new TimeOnly();
                TimeDuration timeDuration = new TimeDuration("1 day");
                long l2 = timeDuration.inMilliseconds();
                long l3 = timeOnly2.inMillis();
                TimeDuration timeDuration2 = l3 > (l = (long)timeOnly.inMillis()) ? TimeDuration.fromMilliseconds(l + l2 - l3) : TimeDuration.fromMilliseconds(l - l3);
                return ThreadScheduler.this._delegate.scheduleAtFixedRate(runnable2, timeDuration2.inMilliseconds(), timeDuration.inMilliseconds(), TimeUnit.MILLISECONDS);
            }
        });
    }

    public ScheduledFuture<?> scheduleRepeating(final String string, final TimeDuration timeDuration, final boolean bl, final Runnable runnable) {
        return this.processSF(new Action(){

            @Override
            Future<?> apply() {
                Runnable runnable2 = ThreadScheduler.this.wrapRunnable(string, runnable);
                long l = 0L;
                if (!bl) {
                    l = timeDuration.inMilliseconds();
                }
                return ThreadScheduler.this._delegate.scheduleAtFixedRate(runnable2, l, timeDuration.inMilliseconds(), TimeUnit.MILLISECONDS);
            }
        });
    }

    public synchronized void start() {
        if (this._actionsToScheduleOnStart != null) {
            List<Action> list = this._actionsToScheduleOnStart;
            this._actionsToScheduleOnStart = null;
            this.logger.info((Object)"starting");
            for (Action action : list) {
                action.restore();
            }
        } else {
            this.logger.warn((Object)"already started - ignoring request to start", (Object)new Throwable());
        }
    }

    public boolean isStarted() {
        return this._actionsToScheduleOnStart != null;
    }

    public void shutdown() {
        this._delegate.shutdownNow();
    }

    ScheduledExecutorService getDelegate() {
        return this._delegate;
    }

    void initializeThread(Thread thread, int n) {
        thread.setDaemon(true);
        thread.setName("scheduled-" + StringX.padLeft(thread.getId(), 5, '0') + "-" + StringX.padLeft(n, 3, '0'));
    }

    synchronized Future<?> process(Action action) {
        if (this._actionsToScheduleOnStart == null) {
            return action.apply();
        }
        this._actionsToScheduleOnStart.add(action);
        return action.createScheduledFutureProxy();
    }

    synchronized ScheduledFuture<?> processSF(Action action) {
        return (ScheduledFuture)this.process(action);
    }

    private Runnable wrapRunnable(String string, Runnable runnable) {
        return this._runnableWrapper.wrap(string, runnable);
    }

    abstract class Action {
        volatile boolean _canceled = false;
        volatile Future<?> _actualFuture;

        Action() {
        }

        void restore() {
            if (!this._canceled) {
                this._actualFuture = this.apply();
            }
        }

        abstract Future<?> apply();

        ScheduledFuture<?> createScheduledFutureProxy() {
            return new ScheduledFuture<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean cancel(boolean bl) {
                    ThreadScheduler threadScheduler = ThreadScheduler.this;
                    synchronized (threadScheduler) {
                        if (Action.this._actualFuture == null) {
                            Action.this._canceled = true;
                            return true;
                        }
                        return Action.this._actualFuture.cancel(bl);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int compareTo(Delayed delayed) {
                    ThreadScheduler threadScheduler = ThreadScheduler.this;
                    synchronized (threadScheduler) {
                        if (Action.this._actualFuture != null && Action.this._actualFuture instanceof ScheduledFuture) {
                            return ((ScheduledFuture)Action.this._actualFuture).compareTo(delayed);
                        }
                        return new Long(Integer.MAX_VALUE).compareTo(delayed.getDelay(TimeUnit.MILLISECONDS));
                    }
                }

                @Override
                public Object get() throws InterruptedException, ExecutionException {
                    while (true) {
                        try {
                            return this.get(1L, TimeUnit.DAYS);
                        }
                        catch (TimeoutException timeoutException) {
                            continue;
                        }
                        break;
                    }
                }

                @Override
                public Object get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                    if (Action.this._actualFuture == null) {
                        throw new RuntimeException("implement me");
                    }
                    return Action.this._actualFuture.get(l, timeUnit);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public long getDelay(TimeUnit timeUnit) {
                    ThreadScheduler threadScheduler = ThreadScheduler.this;
                    synchronized (threadScheduler) {
                        if (Action.this._actualFuture != null && Action.this._actualFuture instanceof ScheduledFuture) {
                            return ((ScheduledFuture)Action.this._actualFuture).getDelay(timeUnit);
                        }
                        return Integer.MAX_VALUE;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isCancelled() {
                    ThreadScheduler threadScheduler = ThreadScheduler.this;
                    synchronized (threadScheduler) {
                        if (Action.this._actualFuture == null) {
                            return Action.this._canceled;
                        }
                        return Action.this._actualFuture.isCancelled();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isDone() {
                    ThreadScheduler threadScheduler = ThreadScheduler.this;
                    synchronized (threadScheduler) {
                        if (Action.this._actualFuture == null) {
                            return false;
                        }
                        return Action.this._actualFuture.isDone();
                    }
                }
            };
        }
    }
}

