/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import net.model3.lang.ByteSize;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;

public class SystemX {
    private static final Logger logger = LoggerHelper.getLogger();

    public static String identityHexHashCode(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    public static void arraycopy(Object[] objectArray, Object[] objectArray2) {
        int n = Math.min(objectArray.length, objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + SystemX.identityHexHashCode(object);
    }

    public static void sleep(TimeDuration timeDuration) {
        logger.trace((Object)("sleeping for " + timeDuration));
        try {
            Thread.sleep(timeDuration.inMilliseconds());
        }
        catch (InterruptedException interruptedException) {
            logger.warn((Object)"waiting interupted", (Object)interruptedException);
        }
    }

    public static void sleep(long l) {
        SystemX.sleep(new TimeDuration(l));
    }

    public static Directory getTempDirectory() {
        return new Directory(System.getProperty("java.io.tmpdir"));
    }

    public static boolean isJDK5OrGreater() {
        String string = System.getProperty("java.version");
        int n = StringX.countOccurences(string, ".");
        if (n > 1) {
            int n2 = string.indexOf(46);
            int n3 = string.indexOf(46, n2 + 1);
            string = string.substring(0, n3);
        }
        try {
            double d = Double.parseDouble(string);
            return d >= 1.5;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static long usedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static void logMemoryUsage() {
        Logger logger = LoggerHelper.getLogger("memory");
        Runtime runtime = Runtime.getRuntime();
        logger.debug("free={}  max={}  total={}  used={}", SystemX.byteSize(runtime.freeMemory()), SystemX.byteSize(runtime.maxMemory()), SystemX.byteSize(runtime.totalMemory()), SystemX.byteSize(SystemX.usedMemory()));
    }

    private static String byteSize(long l) {
        return (int)new ByteSize(l).inMegabytes() + "mb";
    }

    public static void gcCycle() {
        SystemX.gcCycle(Integer.MAX_VALUE);
    }

    public static void gcCycle(int n) {
        int n2;
        logger.debug((Object)"gcCycle() started");
        long l = SystemX.usedMemory();
        for (n2 = 0; n2 < n; ++n2) {
            System.gc();
            long l2 = SystemX.usedMemory();
            if (l2 >= l) break;
            l = l2;
        }
        logger.debug((Object)("gcCycle() completed at cycle # " + n2));
    }

    public static boolean isWindowsXP() {
        return System.getProperty("os.name", "").equals("Windows XP");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name", "").contains("Windows");
    }

    public static boolean isMacOsX() {
        return System.getProperty("os.name", "").equals("Mac OS X");
    }
}

