/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.collections.ArrayX;
import net.model3.collections.ListX;
import net.model3.lang.ExceptionPropagator;

public final class StringX {
    static final char UNPRINTABLE_CHARACTER = '~';
    static final boolean[] printableCharacters_ = new boolean[256];

    public static final boolean contains(String string, String string2) {
        return StringX.contains(string, string2, false);
    }

    public static String blankString(int n) {
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static final boolean contains(String string, String string2, boolean bl) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(n2);
            if (bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c == c2) {
                if (++n2 != string2.length()) continue;
                return true;
            }
            n2 = 0;
        }
        return false;
    }

    public static String getLongestString(String ... stringArray) {
        String string = null;
        for (String string2 : stringArray) {
            if (string2 == null || string != null && string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }

    public static String arrayToString(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return "<null>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray.length > 1 || !bl) {
            stringBuilder.append('{');
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (objectArray[i] instanceof String) {
                stringBuilder.append('\"');
                stringBuilder.append(objectArray[i].toString());
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(objectArray[i]);
        }
        if (objectArray.length > 1 || !bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public static boolean startsWith(String string, String string2, boolean bl) {
        if (!bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return string.startsWith(string2);
    }

    public static final String trimRight(String string) {
        int n;
        int n2;
        for (n2 = n = string.length() - 1; n2 >= 0 && Character.isWhitespace(string.charAt(n2)); --n2) {
        }
        if (n2 != n) {
            return string.substring(0, n2 + 1);
        }
        return string;
    }

    public static final String trimLeft(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n == 0) {
            return string;
        }
        return string.substring(n);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "com.aaaa.bbbb.cccc.dddd";
        System.out.println(StringX.replace(string, "b", "xxxxxxx"));
    }

    public static final String padNumeric(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        StringX.appendNumeric(stringBuilder, n, n2);
        return stringBuilder.toString();
    }

    public static final String padNumeric(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        StringX.appendNumeric(stringBuilder, l, n);
        return stringBuilder.toString();
    }

    public static final String padRight(Object object, int n) {
        return StringX.padRight(object, n, ' ', true);
    }

    public static final String padRight(Object object, int n, boolean bl) {
        return StringX.padRight(object, n, ' ', bl);
    }

    public static final String padRight(Object object, int n, char c, boolean bl) {
        String string = object == null ? "null" : object.toString();
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        int n3 = n - n2;
        if (n3 < 1) {
            if (bl) {
                return string.substring(0, n);
            }
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        StringX.append(stringBuilder, string, n, c);
        return stringBuilder.toString();
    }

    public static final String padLeft(Object object, int n) {
        return StringX.padLeft(object, n, ' ');
    }

    public static final String padLeft(Object object, int n, char c) {
        String string = object.toString();
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        int n3 = n - n2;
        if (n3 < 1) {
            int n4 = n2 - n;
            return string.substring(n4, n4 + n);
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static final void appendRepeat(Appendable appendable, String string, int n) {
        try {
            for (int i = 0; i < n; ++i) {
                appendable.append(string);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static final void append(Appendable appendable, String string, int n) {
        StringX.append(appendable, string, n, ' ');
    }

    public static final void append(Appendable appendable, String string, int n, char c) {
        try {
            int n2;
            if (string == null) {
                string = "";
            }
            if ((n2 = string.length()) == n) {
                appendable.append(string);
                return;
            }
            int n3 = n - n2;
            if (n3 < 0) {
                appendable.append(string.substring(0, n));
                return;
            }
            appendable.append(string);
            for (int i = 0; i < n3; ++i) {
                appendable.append(c);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static final void appendNumeric(Appendable appendable, long l, int n) {
        StringX.appendNumeric(appendable, l, n, '0');
    }

    public static final void appendNumeric(Appendable appendable, long l, int n, char c) {
        try {
            String string = String.valueOf(l);
            int n2 = string.length();
            if (n2 == n) {
                appendable.append(string);
                return;
            }
            int n3 = n - n2;
            if (n3 < 0) {
                int n4 = n2 - n;
                String string2 = string.substring(n4, n4 + n);
                appendable.append(string2);
                return;
            }
            for (int i = 0; i < n3; ++i) {
                appendable.append(c);
            }
            appendable.append(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static boolean isNotBlank(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!StringX.isBlankImpl(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isBlankImpl(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (StringX.isBlankImpl(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String string) {
        return StringX.isBlankImpl(string);
    }

    public static boolean isNotBlank(String string) {
        return !StringX.isBlankImpl(string);
    }

    public static final boolean isPrintable(char c) {
        return printableCharacters_[c];
    }

    public static final String getClassname(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? string : string.substring(n + 1);
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        String string4 = string.substring(0, n) + string3 + string.substring(n + string2.length());
        return string4;
    }

    public static String trimToMaximumLength(String string, int n, String string2) {
        if (string.length() < n) {
            return string;
        }
        return String.valueOf(string.substring(0, n - string2.length())) + String.valueOf(string2);
    }

    public static final String stripQuotes(String string) {
        boolean bl = false;
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return string.substring(1, string.length() - 1);
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static int indexOf(String string, String string2, boolean bl, int n) {
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(n4)) || bl && Character.toLowerCase(c2) == Character.toLowerCase(c)) {
                if (++n4 != n3) continue;
                return i - n3 + 1;
            }
            n4 = 0;
        }
        return -1;
    }

    public static boolean isQuoted(String string) {
        char c;
        if (string.length() < 2) {
            return false;
        }
        char c2 = string.charAt(0);
        return c2 == (c = string.charAt(string.length() - 1)) && (c == '\'' || c == '\"');
    }

    public static String unQuote(String string) {
        if (!StringX.isQuoted(string)) {
            throw new RuntimeException("string is not quoted.  String=" + string);
        }
        return string.substring(1, string.length() - 1);
    }

    public static String arrayToHexString(byte[] byArray) {
        return StringX.arrayToHexString(byArray, byArray.length);
    }

    public static String arrayToHexString(byte[] byArray, int n) {
        return StringX.arrayToHexString("", byArray, n);
    }

    public static String arrayToHexString(String string, byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        StringBuilder stringBuilder2 = null;
        for (int i = 0; i < n; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    stringBuilder2.append("'");
                    stringBuilder.append(stringBuilder2.toString());
                    stringBuilder.append("\n");
                    stringBuilder.append(string);
                }
                stringBuilder2 = new StringBuilder(" '");
                String string2 = Integer.toHexString(i);
                for (int j = string2.length(); j < 4; ++j) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(string2);
                stringBuilder.append("  ");
            }
            char c = StringX.getPrintableAsciiChar((char)(byArray[i] & 0xFF));
            stringBuilder2.append(c);
            String string3 = Integer.toHexString(0xFF & byArray[i]);
            if (string3.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string3);
            stringBuilder.append(" ");
            if (i != n - 1) continue;
            for (int j = i % 16 + 1; j < 16; ++j) {
                stringBuilder.append("   ");
            }
            stringBuilder2.append("'");
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    public static byte hexStringToByte(String string) {
        return (byte)Integer.parseInt(string, 16);
    }

    public static String byteToHexString(byte by) {
        String string = Integer.toHexString(by & 0xFF);
        switch (string.length()) {
            case 0: {
                string = "00";
            }
            case 1: {
                string = "0" + string;
            }
        }
        return string;
    }

    public static char getPrintableAsciiChar(char c) {
        if (StringX.isPrintable(c)) {
            return c;
        }
        return '~';
    }

    public static boolean containsAnyOfTheseCharacters(String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    public static int countOccurences(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n = string.indexOf(string2, n3)) < 0) {
                return n2;
            }
            ++n2;
        } while ((n3 = n + string2.length()) <= string.length());
        return n2;
    }

    public static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String getFirstLine(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            return string2;
        }
        catch (IOException iOException) {
            throw ExceptionPropagator.wrap(iOException);
        }
    }

    public static String escapeJavaString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String camelCaseToEnglish(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String indent(String string, String string2) {
        return StringX.indent(string, string2, true);
    }

    public static String indent(String string, String string2, boolean bl) {
        try {
            String string3;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("\n");
                }
                if (bl || stringBuilder.length() != 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static <T> String join(Object[] objectArray, String string) {
        return StringX.join(ArrayX.asList(objectArray), string, null);
    }

    public static <T> String join(Iterable<?> iterable, String string) {
        return StringX.join(iterable, string, true, null);
    }

    public static <T> String join(Iterable<?> iterable, String string, Converter<T> converter) {
        return StringX.join(iterable, string, true, converter);
    }

    public static <T> String join(Iterable<?> iterable, String string, boolean bl, Converter<T> converter) {
        if (converter == null) {
            converter = new ConverterAdapter();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            String string3;
            Object obj;
            Object obj2 = obj = iterator.next();
            if (!bl && obj2 == null || (string3 = converter.valueToString(obj2)) == null) continue;
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            string2 = string;
        }
        return stringBuilder.toString();
    }

    public static String formatCommas(int n) {
        return StringX.formatCommas(String.valueOf(n));
    }

    public static String formatCommas(long l) {
        return StringX.formatCommas(String.valueOf(l));
    }

    public static String formatCommas(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(46) > -1 ? string.indexOf(46) : string.length();
        int n2 = string.indexOf(45) == 0 ? 1 : 0;
        String string2 = string.substring(n2, n);
        int n3 = 0;
        int n4 = string2.length();
        for (int i = 0; i < n4; ++i) {
            if (n3 == 3) {
                arrayList.add(0, ",");
                n3 = 0;
            }
            ++n3;
            arrayList.add(0, string2.substring(n4 - i - 1, n4 - i));
        }
        Iterator iterator = arrayList.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
        }
        return string.substring(0, n2) + stringBuilder.toString() + string.substring(n);
    }

    public static String formatCommas(float f) {
        return StringX.formatCommas(String.valueOf(f));
    }

    public static String getAsciiString(int n) {
        try {
            return new String(new byte[]{(byte)n}, "Cp1252");
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static String safeSubstring(String string, int n, int n2) {
        if (string.length() <= n) {
            return null;
        }
        if (string.length() < n2) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    public static String getFirstNonBlank(String ... stringArray) {
        for (String string : stringArray) {
            if (!StringX.isNotBlank(string)) continue;
            return string;
        }
        return null;
    }

    public static String getFirstNonBlank(Iterable<String> iterable) {
        for (String string : iterable) {
            if (!StringX.isNotBlank(string)) continue;
            return string;
        }
        return null;
    }

    public static List<String> lines(String string) {
        try {
            String string2;
            List<String> list = ListX.create();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                list.add(string2);
            }
            return list;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static String combineNameParts(String string, String string2, String string3) {
        if (StringX.isBlank(string, string2, string3)) {
            return "";
        }
        return string + ", " + string2 + " " + string3;
    }

    public static final int compareTo(String string, String string2) {
        if (string == null || string2 == null) {
            if (string != null) {
                return 1;
            }
            if (string2 != null) {
                return -1;
            }
            return 0;
        }
        return string.compareTo(string2);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            StringX.printableCharacters_[i] = !Character.isISOControl((char)i);
        }
    }
}

