/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import net.model3.chrono.DateTime;
import net.model3.lang.TimeDuration;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class StopWatch {
    private TimeDuration elapsed_ = TimeDuration.ZERO;
    private Long start_;
    private Level loggingLevel_;
    private Logger logger_ = LoggerHelper.getLogger();
    private String description_;

    public StopWatch() {
        this(null);
    }

    public StopWatch(String string) {
        this(string, true, null, null);
    }

    public StopWatch(String string, Level level) {
        this(string, true, level, null);
    }

    public StopWatch(String string, Level level, Logger logger) {
        this(string, true, level, logger);
    }

    public StopWatch(String string, boolean bl, Level level, Logger logger) {
        this.loggingLevel_ = level;
        this.logger_ = logger == null ? LoggerHelper.getLogger() : logger;
        this.description_ = string == null ? this.toString() : string;
        this.description_ = this.description_ + ": ";
        if (bl) {
            this.start();
        }
    }

    public TimeDuration stopStart(String string) {
        TimeDuration timeDuration = this.stop(null);
        if (this.loggingLevel_ != null) {
            this.logger_.log(this.loggingLevel_, " {} {} lap {}", this.description_, string, timeDuration);
        }
        this.start(null);
        return timeDuration;
    }

    public TimeDuration elapsed(String string) {
        TimeDuration timeDuration = this.elapsed();
        if (this.loggingLevel_ != null) {
            this.logger_.log(this.loggingLevel_, " {} {} elapsed {}", this.description_, string, timeDuration);
        }
        return timeDuration;
    }

    public TimeDuration elapsed() {
        if (this.isStarted()) {
            return new TimeDuration(this.diff() + this.elapsed_.inMilliseconds());
        }
        return this.elapsed_;
    }

    public void start() {
        this.start("");
    }

    public void start(String string) {
        if (this.isStarted()) {
            this.logger_.warn((Object)(this.description_ + "start() timer is already started ignoring method call"));
        } else {
            this.reset(false);
            if (this.loggingLevel_ != null && string != null) {
                this.logger_.log(this.loggingLevel_, this.description_ + string + " started at " + new DateTime(this.start_));
            }
        }
    }

    public boolean isStarted() {
        return this.start_ != null;
    }

    public TimeDuration reset() {
        return this.reset(true);
    }

    private TimeDuration reset(boolean bl) {
        TimeDuration timeDuration = this.isStarted() ? this.stop() : null;
        if (bl) {
            this.elapsed_ = TimeDuration.ZERO;
        }
        this.start_ = System.currentTimeMillis();
        return timeDuration;
    }

    public TimeDuration resetStart() {
        TimeDuration timeDuration = this.reset();
        this.start();
        return timeDuration;
    }

    public TimeDuration stop() {
        return this.stop("");
    }

    private long diff() {
        return System.currentTimeMillis() - this.start_;
    }

    public TimeDuration stop(String string) {
        if (this.isStarted()) {
            TimeDuration timeDuration = new TimeDuration(this.diff());
            if (this.loggingLevel_ != null && string != null) {
                this.logger_.log(this.loggingLevel_, this.description_ + string + " stopped " + string + "  " + timeDuration);
            }
            TimeDuration timeDuration2 = new TimeDuration(this.elapsed_.inMilliseconds() + timeDuration.inMilliseconds());
            this.start_ = null;
            this.elapsed_ = TimeDuration.ZERO;
            return timeDuration2;
        }
        throw new RuntimeException("timer is not started");
    }

    public Logger getLogger() {
        return this.logger_;
    }

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel_;
    }

    public void setLoggingLevel(Level level) {
        this.loggingLevel_ = level;
    }
}

