/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import net.model3.chrono.DateTime;
import net.model3.lang.TimeDuration;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class NanosStopWatch {
    private TimeDuration elapsed_ = TimeDuration.ZERO;
    private Long nanos_;
    private Long start_;
    private Level loggingLevel_;
    private Logger logger_ = LoggerHelper.getLogger();
    private String description_;

    public NanosStopWatch() {
        this(null);
    }

    public NanosStopWatch(String string) {
        this(string, true, null, null);
    }

    public NanosStopWatch(String string, Level level) {
        this(string, true, level, null);
    }

    public NanosStopWatch(String string, Level level, Logger logger) {
        this(string, true, level, logger);
    }

    public NanosStopWatch(String string, boolean bl, Level level, Logger logger) {
        this.loggingLevel_ = level == null ? Level.TRACE : level;
        this.logger_ = logger == null ? LoggerHelper.getLogger() : logger;
        this.description_ = string == null ? this.toString() : string;
        this.description_ = this.description_ + ": ";
        if (bl) {
            this.start();
        }
    }

    public TimeDuration elapsed() {
        if (this.isStarted()) {
            long l = this.diff();
            return new TimeDuration(l / 1000000L + this.elapsed_.inMilliseconds());
        }
        return this.elapsed_;
    }

    public void start() {
        this.start("");
    }

    public void start(String string) {
        if (this.isStarted()) {
            this.logger_.warn((Object)(this.description_ + "start() timer is already started ignoring method call"));
        } else {
            this.reset(false);
            if (this.loggingLevel_ != null) {
                this.logger_.log(this.loggingLevel_, this.description_ + string + " started at " + new DateTime(this.start_));
            }
        }
    }

    public boolean isStarted() {
        return this.start_ != null;
    }

    public TimeDuration reset() {
        return this.reset(true);
    }

    private TimeDuration reset(boolean bl) {
        TimeDuration timeDuration = this.isStarted() ? this.stop() : null;
        if (bl) {
            this.elapsed_ = TimeDuration.ZERO;
        }
        this.start_ = System.currentTimeMillis();
        this.nanos_ = System.nanoTime();
        return timeDuration;
    }

    public TimeDuration resetStart() {
        TimeDuration timeDuration = this.reset();
        this.start();
        return timeDuration;
    }

    public TimeDuration stop() {
        return this.stop("");
    }

    public long diff() {
        return System.nanoTime() - this.nanos_;
    }

    public TimeDuration stop(String string) {
        if (this.isStarted()) {
            long l = this.diff();
            TimeDuration timeDuration = new TimeDuration(l / 1000000L);
            long l2 = l - l / 1000000L * 1000000L;
            if (this.loggingLevel_ != null) {
                this.logger_.log(this.loggingLevel_, this.description_ + string + " stopped " + string + "  " + timeDuration + " " + l2 + "ns");
            }
            this.elapsed_ = new TimeDuration(this.elapsed_.inMilliseconds() + timeDuration.inMilliseconds());
            this.start_ = null;
            return this.elapsed_;
        }
        throw new RuntimeException("timer is not started");
    }

    public Logger getLogger() {
        return this.logger_;
    }

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel_;
    }

    public void setLoggingLevel(Level level) {
        this.loggingLevel_ = level;
    }
}

