/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import net.model3.lang.Immutable;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.util.BigDecimalX;

@Immutable
public class Money
implements Serializable {
    private static final long serialVersionUID = -1799304802105178139L;
    private static final Logger logger = LoggerHelper.getLogger(Money.class);
    private static final int SCALE = 2;
    private static final int ROUNDING = 4;
    public static final Money ZERO = new Money("0");
    private final BigDecimal _amount;

    private static BigDecimal bigDecimalFactory(String string) {
        string = string == null ? "0" : string.replace("$", "").replace(",", "");
        return Money.scaleBigDecimal(new BigDecimal(string));
    }

    private static BigDecimal bigDecimalFactory(double d) {
        return Money.scaleBigDecimal(new BigDecimal(d));
    }

    private static BigDecimal scaleBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 4);
    }

    public Money(String string) {
        this._amount = Money.bigDecimalFactory(string);
    }

    public Money(long l) {
        this._amount = Money.bigDecimalFactory(l);
    }

    public Money(double d) {
        this._amount = Money.bigDecimalFactory(d);
    }

    public Money(BigDecimal bigDecimal) {
        this._amount = Money.scaleBigDecimal(bigDecimal);
    }

    public Money add(Money money) {
        return this.add(money._amount);
    }

    public Money add(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this._amount.add(bigDecimal);
        return new Money(bigDecimal2);
    }

    public Money multiply(BigDecimal bigDecimal) {
        return new Money(bigDecimal.multiply(this._amount));
    }

    public BigDecimal divide(Money money, int n, int n2) {
        return this._amount.divide(money._amount, n, n2);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        return this._amount.divide(bigDecimal, n, n2);
    }

    public Money multiply(long l) {
        return new Money(new BigDecimal(l).multiply(this._amount));
    }

    public Money divide(long l) {
        return this.divide(new BigDecimal(l));
    }

    public Money divide(BigDecimal bigDecimal) {
        return new Money(this._amount.divide(bigDecimal, 4));
    }

    public Money divide(BigDecimal bigDecimal, int n) {
        return new Money(this._amount.divide(bigDecimal, n));
    }

    public Money divide(int n, int n2) {
        return this.divide(new BigDecimal(n), n2);
    }

    public Money subtract(Money money) {
        return new Money(this._amount.subtract(money._amount));
    }

    public int compareTo(Money money) {
        return this._amount.compareTo(money._amount);
    }

    public String formatCommas() {
        return Money.formatCommas(this);
    }

    public static String formatCommas(Money money) {
        return "$" + BigDecimalX.formatCommas(money.asBigDecimal());
    }

    public BigDecimal asBigDecimal() {
        return this._amount;
    }

    public String toString() {
        return "$" + BigDecimalX.formatCommas(this._amount);
    }

    public boolean isZero() {
        return this._amount.compareTo(BigDecimalX.ZERO) == 0;
    }

    public boolean equals(Object object) {
        Money money = (Money)object;
        if (money == null) {
            return false;
        }
        if (this._amount == null && money._amount == null) {
            return true;
        }
        if (this._amount == null || money._amount == null) {
            return false;
        }
        return money._amount.equals(this._amount);
    }

    public int intValue() {
        return this._amount.intValue();
    }

    public float floatValue() {
        return this._amount.floatValue();
    }

    public Money average(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return new Money(BigDecimalX.getAverage(this.asBigDecimal(), bigDecimal, bigDecimal2, 2));
    }

    public Money averageToMonthly(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal(365).divide(new BigDecimal(12), 10, 4);
        return this.average(bigDecimal, bigDecimal2);
    }
}

