/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public enum ModifierX {
    FINAL("final", 16),
    STATIC("static", 8),
    NATIVE("native", 256),
    ABSTRACT("abstract", 1024),
    PRIVATE("private", 2),
    PUBLIC("public", 1),
    PROTECTED("protected", 4),
    INTERFACE("interface", 512),
    STRICT("strict", 2048),
    SYNCHRONIZED("synchronized", 32),
    TRANSIENT("transient", 128),
    VOLATILE("volatile", 64),
    BRIDGE("bridge", 64),
    ENUM("enum", 16384),
    ANNOTATION("annotation", 8192),
    SYNTHETIC("synthetic", 4096),
    VARARGS("varargs", 128);

    private String keyword_;
    private int bitMask_;

    private ModifierX(String string2, int n2) {
        this.keyword_ = string2;
        this.bitMask_ = n2;
    }

    public String getKeyword() {
        return this.keyword_;
    }

    public int getBitMask() {
        return this.bitMask_;
    }

    public boolean isIn(Method method) {
        return this.isIn(method.getModifiers());
    }

    public boolean isIn(Class<?> clazz) {
        return this.isIn(clazz.getModifiers());
    }

    public boolean isIn(Field field) {
        return this.isIn(field.getModifiers());
    }

    public boolean isIn(int n) {
        return (this.bitMask_ & n) != 0;
    }

    public static String getModifiers(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        for (ModifierX modifierX : (ModifierX[])ModifierX.class.getEnumConstants()) {
            if (!modifierX.isIn(n)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(modifierX.getKeyword());
            n2 ^= modifierX.getBitMask();
        }
        if (n2 != 0) {
            throw new RuntimeException("not all modifiers found " + n2 + "  " + n + " " + stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    public static Set<ModifierX> getModifierSet(int n) {
        HashSet<ModifierX> hashSet = new HashSet<ModifierX>();
        for (ModifierX modifierX : (ModifierX[])ModifierX.class.getEnumConstants()) {
            if (!modifierX.isIn(n)) continue;
            hashSet.add(modifierX);
        }
        return hashSet;
    }
}

