/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.math.BigDecimal;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import org.apache.log4j.BasicConfigurator;

public class MemoryUsage {
    private static final Logger logger = LoggerHelper.getLogger();

    public static void logit() {
        if (logger.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            String string = MemoryUsage.inMegabytes(runtime.maxMemory());
            String string2 = MemoryUsage.inMegabytes(runtime.totalMemory());
            String string3 = MemoryUsage.inMegabytes(runtime.freeMemory());
            logger.info((Object)("max=" + string + "  free=" + string3 + "  used=" + string2));
        }
    }

    private static String inMegabytes(long l) {
        return new BigDecimal((double)l / 1048576.0).setScale(2, 6).toString() + "mb";
    }

    public static void logitRepeatedlyGui(TimeDuration timeDuration) {
        ThreadScheduler threadScheduler = (ThreadScheduler)DependencyInjector.get().getInstance(ThreadScheduler.class);
        threadScheduler.scheduleRepeating("logit", timeDuration, new Runnable(){

            @Override
            public void run() {
                MemoryUsage.logit();
            }
        });
    }

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        MemoryUsage.logit();
    }
}

