/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public final class MemoryCounter {
    private static final MemorySizes sizes = new MemorySizes();
    private final Map visited = new IdentityHashMap();
    private final Stack stack = new Stack();

    public synchronized long estimate(Object object) {
        assert (this.visited.isEmpty());
        assert (this.stack.isEmpty());
        long l = this._estimate(object);
        while (!this.stack.isEmpty()) {
            l += this._estimate(this.stack.pop());
        }
        this.visited.clear();
        return l;
    }

    private boolean skipObject(Object object) {
        if (object instanceof String && object == ((String)object).intern()) {
            return true;
        }
        return object == null || this.visited.containsKey(object);
    }

    private long _estimate(Object object) {
        Class<?> clazz;
        if (this.skipObject(object)) {
            return 0L;
        }
        this.visited.put(object, null);
        long l = 0L;
        if (clazz.isArray()) {
            return this._estimateArray(object);
        }
        for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (Modifier.isStatic(fieldArray[i].getModifiers())) continue;
                if (fieldArray[i].getType().isPrimitive()) {
                    l += (long)sizes.getPrimitiveFieldSize(fieldArray[i].getType());
                    continue;
                }
                l += (long)sizes.getPointerSize();
                fieldArray[i].setAccessible(true);
                try {
                    Object object2 = fieldArray[i].get(object);
                    if (object2 == null) continue;
                    this.stack.add(object2);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                    continue;
                }
            }
        }
        return this.roundUpToNearestEightBytes(l += (long)sizes.getClassSize());
    }

    private long roundUpToNearestEightBytes(long l) {
        if (l % 8L != 0L) {
            l += 8L - l % 8L;
        }
        return l;
    }

    protected long _estimateArray(Object object) {
        long l = 16L;
        int n = Array.getLength(object);
        if (n != 0) {
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz.isPrimitive()) {
                l += (long)(n * sizes.getPrimitiveArrayElementSize(clazz));
            } else {
                for (int i = 0; i < n; ++i) {
                    l += (long)sizes.getPointerSize() + this._estimate(Array.get(object, i));
                }
            }
        }
        return l;
    }

    static class MemorySizes {
        private final Map primitiveSizes = new IdentityHashMap(){
            {
                this.put(Boolean.TYPE, new Integer(1));
                this.put(Byte.TYPE, new Integer(1));
                this.put(Character.TYPE, new Integer(2));
                this.put(Short.TYPE, new Integer(2));
                this.put(Integer.TYPE, new Integer(4));
                this.put(Float.TYPE, new Integer(4));
                this.put(Double.TYPE, new Integer(8));
                this.put(Long.TYPE, new Integer(8));
            }
        };

        MemorySizes() {
        }

        public int getPrimitiveFieldSize(Class clazz) {
            return (Integer)this.primitiveSizes.get(clazz);
        }

        public int getPrimitiveArrayElementSize(Class clazz) {
            return this.getPrimitiveFieldSize(clazz);
        }

        public int getPointerSize() {
            return 4;
        }

        public int getClassSize() {
            return 8;
        }
    }
}

