/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.model3.lang.ExceptionPropagator;

public class Memoizer
implements InvocationHandler {
    Object _delegate;
    Map<Method, Map<List<Object>, Object>> _caches = new ConcurrentHashMap<Method, Map<List<Object>, Object>>();

    public static <T> T memoize(T t, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(t.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new Memoizer(t));
    }

    public static <T> T memoize(T t, Class<?>[] classArray) {
        return (T)Proxy.newProxyInstance(t.getClass().getClassLoader(), classArray, (InvocationHandler)new Memoizer(t));
    }

    private Memoizer(Object object) {
        this._delegate = object;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        try {
            List<Object> list;
            if (method.getReturnType().equals(Void.TYPE)) {
                return this.invoke(method, objectArray);
            }
            Map map = this.getCache(method);
            Object object2 = map.get(list = Arrays.asList(objectArray));
            if (object2 == null && !map.containsKey(list)) {
                object2 = this.invoke(method, objectArray);
                map.put(list, object2);
            }
            return object2;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked(exception);
        }
    }

    Object invoke(Method method, Object[] objectArray) {
        try {
            return method.invoke(this._delegate, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ExceptionPropagator.throwUnchecked(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked(exception);
        }
    }

    Map getCache(Method method) {
        Map<List<Object>, Object> map = this._caches.get(method);
        if (map == null) {
            map = new ConcurrentHashMap<List<Object>, Object>();
            this._caches.put(method, map);
        }
        return map;
    }
}

