/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.collections.ListX;
import net.model3.lang.AbstractComparable;
import net.model3.lang.ExceptionPropagator;
import net.model3.util.StringJoiner;

public abstract class Measurement<T extends Measurement>
extends AbstractComparable<T>
implements Serializable {
    private static final long serialVersionUID = 6467222170292961921L;
    protected long _value;
    private String _originalString;

    protected Measurement(double d, MetaMeasurement.Unit unit) {
        this._value = (long)(d * (double)unit._multiplier.longValue());
        this._originalString = "";
    }

    protected Measurement(String string) {
        this._originalString = string;
        string = string.trim();
        if (string.equalsIgnoreCase("forever") || string.equalsIgnoreCase("infinity") || string.equalsIgnoreCase("never")) {
            this._value = Long.MAX_VALUE;
        } else {
            Matcher matcher = this.getMetaMeasurement().getPattern().matcher(string);
            if (matcher.matches()) {
                matcher = this.getMetaMeasurement().getPattern2().matcher(string);
                matcher.lookingAt();
                do {
                    BigDecimal bigDecimal = new BigDecimal(matcher.group(1));
                    String string2 = matcher.group(2);
                    MetaMeasurement.Unit unit = (MetaMeasurement.Unit)this.getMetaMeasurement()._suffixToUnitMap.get(string2);
                    if (unit == null) {
                        throw new RuntimeException("invalid duration string '" + this._originalString + "' unknown unit of " + string2);
                    }
                    this._value += bigDecimal.multiply(new BigDecimal(unit._multiplier)).longValue();
                } while (matcher.find());
            } else {
                throw new RuntimeException("invalid string '" + this._originalString + "'");
            }
        }
    }

    public String toString(boolean bl) {
        long l = this._value;
        StringBuffer stringBuffer = new StringBuffer();
        for (MetaMeasurement.Unit unit : this.getMetaMeasurement().getUnitsByDescendingMultipler()) {
            if (!unit._useInToString) continue;
            long l2 = l / unit._multiplier;
            l %= unit._multiplier.longValue();
            if (l2 == 0L && (stringBuffer.length() != 0 || unit._multiplier != 1L)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(l2);
            if (bl) {
                stringBuffer.append(" ");
                if (l2 == 1L) {
                    stringBuffer.append(unit._singular);
                    continue;
                }
                stringBuffer.append(unit._plural);
                continue;
            }
            stringBuffer.append(unit._abbreviated);
        }
        return stringBuffer.toString().trim();
    }

    public String asVerboseText() {
        return this.toString(true);
    }

    public String asAbbreviatedText() {
        return this.toString(false);
    }

    public String toString() {
        return this.asAbbreviatedText();
    }

    protected abstract MetaMeasurement getMetaMeasurement();

    protected long getValue() {
        return this._value;
    }

    protected double convertTo(MetaMeasurement.Unit unit) {
        return (double)this.getValue() / (double)unit._multiplier.longValue();
    }

    @Override
    public int compareTo(T t) {
        if (!t.getClass().equals(this.getClass())) {
            throw new ClassCastException("A " + this.getClass().getName() + " object expected.");
        }
        long l = this._value - ((Measurement)t)._value;
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this._value ^ this._value >>> 32);
        return n;
    }

    public boolean notEquals(Object object) {
        return !this.equals(object);
    }

    public String toEstimatedString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = this.getValue();
        for (MetaMeasurement.Unit unit : this.getMetaMeasurement().getUnitsByDescendingMultipler()) {
            if (!unit._useInToString) continue;
            long l2 = l / unit.getMultiplier();
            long l3 = l % unit.getMultiplier();
            if (l2 == 0L && (stringBuffer.length() != 0 || unit.getMultiplier() != 1L)) continue;
            stringBuffer.append(l2);
            int n = (int)(l3 * 10L / unit.getMultiplier());
            if (n != 0) {
                stringBuffer.append(".");
                stringBuffer.append(n);
            }
            if (bl) {
                if (n == 0 && l2 == 1L) {
                    stringBuffer.append(" " + unit.getSingular());
                    break;
                }
                stringBuffer.append(" " + unit.getPlural());
                break;
            }
            stringBuffer.append(" " + unit.getAbbreviated());
            break;
        }
        return stringBuffer.toString().trim();
    }

    public T abs() {
        if (this._value < 0L) {
            try {
                Measurement measurement = (Measurement)this.getClass().newInstance();
                measurement._value = -this._value;
                return (T)measurement;
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap(exception);
            }
        }
        return (T)this;
    }

    public static class MetaMeasurement {
        private String _name;
        private List<Unit> _units = ListX.create();
        private List<Unit> _unitsByDescendingMultipler;
        private Pattern _pattern;
        private Pattern _patttern2;
        private Map<String, Unit> _suffixToUnitMap = new CaseInsensitiveMapWrapper<Unit>();

        public MetaMeasurement(String string) {
            this._name = string;
        }

        public Unit addUnit(long l, String string, String string2, String string3, boolean bl, String ... stringArray) {
            Unit unit = new Unit(l, string, string2, string3, bl, stringArray);
            this._units.add(unit);
            return unit;
        }

        public List<Unit> getUnitsByDescendingMultipler() {
            if (this._unitsByDescendingMultipler == null) {
                ArrayList<Unit> arrayList = new ArrayList<Unit>(this._units);
                Collections.sort(arrayList);
                this._unitsByDescendingMultipler = arrayList;
            }
            return this._unitsByDescendingMultipler;
        }

        public void seal() {
            this.getPattern();
            this.getPattern2();
        }

        public String getAllSuffixesAsString() {
            List list = ListX.create();
            for (Unit unit : this._units) {
                for (String string : unit._suffixes) {
                    list.add(string);
                    this._suffixToUnitMap.put(string, unit);
                }
            }
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return -string.compareTo(string2);
                }
            });
            return new StringJoiner(list, "|").toString();
        }

        public Pattern getPattern2() {
            if (this._patttern2 == null) {
                this._patttern2 = Pattern.compile(" *((?:-)?[0-9]+(?:\\.[0-9]*)?) *(" + this.getAllSuffixesAsString() + ")", 2);
            }
            return this._patttern2;
        }

        public Pattern getPattern() {
            if (this._pattern == null) {
                this._pattern = Pattern.compile("(?:" + this.getPattern2().pattern() + ")+", 2);
            }
            return this._pattern;
        }

        public static class Unit
        implements Comparable<Unit> {
            private final String _singular;
            private final String _plural;
            private final String _abbreviated;
            private final String[] _suffixes;
            private final Long _multiplier;
            private final boolean _useInToString;

            Unit(long l, String string, String string2, String string3, boolean bl, String ... stringArray) {
                this._singular = string;
                this._plural = string2;
                this._abbreviated = string3;
                this._multiplier = l;
                this._useInToString = bl;
                this._suffixes = new String[stringArray.length + 3];
                this._suffixes[0] = string;
                this._suffixes[1] = string2;
                this._suffixes[2] = string3;
                if (stringArray.length > 0) {
                    System.arraycopy(stringArray, 0, this._suffixes, 3, stringArray.length);
                }
            }

            public String getSingular() {
                return this._singular;
            }

            public String getPlural() {
                return this._plural;
            }

            public String getAbbreviated() {
                return this._abbreviated;
            }

            public String[] getSuffixes() {
                return this._suffixes;
            }

            public Long getMultiplier() {
                return this._multiplier;
            }

            public boolean isUseInToString() {
                return this._useInToString;
            }

            @Override
            public int compareTo(Unit unit) {
                return unit._multiplier.compareTo(this._multiplier);
            }

            public String toString() {
                return this._plural;
            }
        }
    }
}

