/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;

public class Executor {
    private static final Logger logger = LoggerHelper.getLogger(Executor.class);
    private String commandLine_;
    private Directory currentDirectory_ = new Directory(".");
    private boolean spawn_ = false;
    private String lastOutput_;
    private String lastError_;
    private Integer lastResult_;
    private boolean failOnNonZeroResult_ = false;
    private TimeDuration timeout_;
    private String inputString_;

    public TimeDuration getTimeout() {
        return this.timeout_;
    }

    public String getInputString() {
        return this.inputString_;
    }

    public void setInputString(String string) {
        this.inputString_ = string;
    }

    public void setTimeout(TimeDuration timeDuration) {
        this.timeout_ = timeDuration;
    }

    public void setCurrentDirectory(Directory directory) {
        this.currentDirectory_ = directory;
    }

    public void setCommandLine(String string) {
        this.commandLine_ = string;
    }

    public String getLastError() {
        return this.lastError_;
    }

    public String getCommandLine() {
        return this.commandLine_;
    }

    public void setSpawn(boolean bl) {
        this.spawn_ = bl;
    }

    public String getLastOutput() {
        return this.lastOutput_;
    }

    public int getLastResult() {
        return this.lastResult_;
    }

    public void execute() {
        ExecutorImpl executorImpl = new ExecutorImpl();
        logger.debug((Object)("running " + this.commandLine_));
        Commandline commandline = new Commandline(this.commandLine_);
        executorImpl.setCommand(commandline);
        executorImpl.setDir(this.currentDirectory_.asCanonicalFile());
        executorImpl.setVMLauncher(false);
        if (this.timeout_ != null) {
            executorImpl.setTimeout(new Long(this.timeout_.inMilliseconds()));
        }
        executorImpl.setSpawn(this.spawn_);
        if (!this.spawn_) {
            executorImpl.setFailIfExecutionFails(true);
            executorImpl.setOutputproperty("output");
            executorImpl.setErrorProperty("error");
            executorImpl.setResultProperty("result");
        }
        if (this.inputString_ != null) {
            executorImpl.setInputString(this.inputString_);
        }
        executorImpl.execute();
        if (this.spawn_) {
            this.lastOutput_ = null;
            this.lastResult_ = null;
            this.lastError_ = null;
        } else {
            this.lastError_ = executorImpl.getProject().getProperty("error");
            this.lastOutput_ = executorImpl.getProject().getProperty("output");
            this.lastResult_ = new Integer(executorImpl.getProject().getProperty("result"));
            if (this.failOnNonZeroResult_ && this.lastResult_ != 0) {
                throw new RuntimeException("result of " + this.lastResult_ + " is non-zero   output is \n" + this.lastOutput_);
            }
        }
    }

    public boolean isFailOnNonZeroResult() {
        return this.failOnNonZeroResult_;
    }

    public void setFailOnNonZeroResult(boolean bl) {
        this.failOnNonZeroResult_ = bl;
    }

    public void logResults() {
        boolean bl = false;
        if (StringX.isNotBlank(this.lastOutput_)) {
            logger.trace((Object)"stdout\n{}", (Object)this.lastOutput_);
            bl = true;
        }
        if (StringX.isNotBlank(this.lastError_)) {
            logger.trace((Object)"stderr\n{}", (Object)this.lastError_);
            bl = true;
        }
        if (!bl) {
            logger.trace((Object)"no stdout or stderr output");
        }
    }

    class ExecutorImpl
    extends ExecTask {
        public ExecutorImpl() {
            Project project = new Project();
            this.setProject(project);
            project.init();
            this.setTaskType("exec");
            this.setTaskName("exec");
            this.setOwningTarget(new Target());
        }
    }
}

