/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import net.model3.lang.StringX;
import net.model3.logging.Level;
import net.model3.logging.Logger;

public class ExceptionPropagator {
    private static final boolean FLATTEN = false;

    public static Throwable getRootCause(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        ExceptionPropagator.loadThrowableChain(throwable, arrayList);
        return (Throwable)arrayList.get(arrayList.size() - 1);
    }

    private static void loadThrowableChain(Throwable throwable, List<Throwable> list) {
        list.add(throwable);
        if (throwable.getCause() != null && throwable.getCause() != throwable) {
            ExceptionPropagator.loadThrowableChain(throwable.getCause(), list);
        }
    }

    public static RuntimeException wrap(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static ServletException wrapServletException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof ServletException) {
            return (ServletException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static RuntimeException wrap(String string, Throwable throwable) {
        return ExceptionPropagator.wrap(string, throwable, null, null);
    }

    public static RuntimeException wrap(String string, Throwable throwable, Logger logger, Level level) {
        if (string == null) {
            string = "";
        }
        if (logger != null && logger.isEnabled(level)) {
            logger.log(level, string, throwable);
        }
        if (StringX.isBlank(string)) {
            return ExceptionPropagator.wrap(throwable);
        }
        return new RuntimeException(string, throwable);
    }

    public static RuntimeException throwUnchecked(Throwable throwable) {
        ExceptionPropagator.throwUncheckedImpl(throwable);
        return null;
    }

    private static <T extends Throwable> void throwUncheckedImpl(Throwable throwable) throws T {
        throw throwable;
    }
}

