/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.model3.collections.MapX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.Executor;
import net.model3.lang.SystemX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class Environment {
    private static final Logger logger = LoggerHelper.getLogger();
    private static Environment instance_;
    private Map<String, String> variableMap_;

    public static final Environment getInstance() {
        if (instance_ == null) {
            instance_ = new Environment();
        }
        return instance_;
    }

    private Environment() {
        this.refresh();
    }

    private void refresh() {
        Object object;
        Map<String, String> map;
        if (SystemX.isJDK5OrGreater()) {
            map = System.getenv();
        } else {
            object = new Executor();
            ((Executor)object).setCommandLine("cmd.exe /c set");
            ((Executor)object).setFailOnNonZeroResult(true);
            ((Executor)object).execute();
            String string = ((Executor)object).getLastOutput();
            string = string.replaceAll("\\\\", "\\\\\\\\");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            try {
                Properties properties = new Properties();
                properties.load(byteArrayInputStream);
                ((InputStream)byteArrayInputStream).close();
                map = new HashMap<String, String>();
                for (Object object2 : properties.keySet()) {
                    String string2 = (String)object2;
                    String string3 = properties.getProperty(string2);
                    map.put(string2, string3);
                }
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap(exception);
            }
        }
        object = new HashMap();
        MapX.cloneWithLowercaseKeys(map, (Map)object);
        this.variableMap_ = object;
    }

    public String get(String string) {
        return this.variableMap_.get(string.toLowerCase());
    }

    public static void main(String[] stringArray) {
        Environment environment = new Environment();
        environment.toString();
        Environment.test(environment, "this is a %Path% test");
        Environment.test(environment, "this is a %Path test");
        Environment.test(environment, "this is a %[Path] test");
    }

    private static void test(Environment environment, String string) {
        System.out.println("'" + string + "=" + environment.resolve(string) + "'");
    }

    public String resolve(String string) {
        return this.resolve(string, false);
    }

    public String resolve(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = string.indexOf(37, n)) < 0) break;
            String string2 = string.substring(n, n4);
            stringBuffer.append(string2);
            char c = string.charAt(n4 + 1);
            switch (c) {
                case '%': {
                    stringBuffer.append('%');
                    n2 = n3 = n4;
                    n += 2;
                    break;
                }
                case '[': {
                    int n5 = string.indexOf(93, n4);
                    if (n5 < 0) {
                        throw new RuntimeException("syntax error no right bracket in '" + string + "'");
                    }
                    n2 = n4 + 2;
                    n3 = n5;
                    n = n3 + 1;
                    break;
                }
                case ' ': {
                    n2 = n3 = n4;
                    n += 2;
                    break;
                }
                default: {
                    n2 = n4 + 1;
                    int n6 = string.indexOf(32, n2);
                    int n7 = string.indexOf(37, n2);
                    if (Character.isLetterOrDigit(c)) {
                        if (n7 != -1 && (n6 == -1 || n6 > n7)) {
                            n3 = n7;
                            n = n7 + 1;
                            break;
                        }
                        if (n6 != -1) {
                            n3 = n = n6;
                            break;
                        }
                        n = n3 = string.length();
                        break;
                    }
                    n = n3 = n2;
                }
            }
            String string3 = string.substring(n2, n3);
            String string4 = this.get(string3);
            if (string4 == null) {
                if (!bl) continue;
                throw new RuntimeException("variable '" + string3 + "' from '" + string + "' not found in environment");
            }
            stringBuffer.append(string4);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }
}

