/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.model3.collections.CollectionX;

public abstract class EnumeratedType
implements Serializable,
Externalizable {
    static final long serialVersionUID = 7185778848818358201L;
    private static final Hashtable subclasses = new Hashtable();
    private String name_;
    private int index_;
    private Vector collection_;

    protected EnumeratedType() {
    }

    protected EnumeratedType(String string) {
        Vector vector = (Vector)subclasses.get(this.getClass());
        if (vector == null) {
            this.collection_ = new Vector();
            subclasses.put(this.getClass(), this.collection_);
        } else {
            this.collection_ = vector;
        }
        if (string != null) {
            if (EnumeratedType.search(string, (Collection)this.collection_) != null) {
                throw new RuntimeException("Name \"" + string + "\" is already used in class " + this.getClass().getName());
            }
            this.name_ = string;
            this.index_ = this.collection_.size();
            this.collection_.add(this);
        } else {
            this.name_ = null;
            this.index_ = -1;
        }
    }

    public String toString() {
        if (this.name_ == null) {
            return this.collection_.toString();
        }
        return this.name_;
    }

    public String getName() {
        return this.name_;
    }

    public int index() {
        return this.index_;
    }

    public EnumeratedType get(int n) {
        return (EnumeratedType)this.collection_.get(n);
    }

    public EnumeratedType get(String string) {
        return EnumeratedType.search(string, (Collection)this.collection_);
    }

    public int count() {
        return this.collection_.size();
    }

    public Iterator iterator() {
        return this.collection_.iterator();
    }

    public Object[] toArray() {
        return CollectionX.toArray(this.collection_, this.getClass());
    }

    protected Object readResolve() throws ObjectStreamException {
        EnumeratedType enumeratedType;
        Vector vector = (Vector)subclasses.get(this.getClass());
        if (vector == null) {
            throw new RuntimeException("EnumeratedType class  not loaded");
        }
        if (this.serializeByName()) {
            enumeratedType = EnumeratedType.search(this.name_, (Collection)vector);
            if (enumeratedType == null) {
                throw new RuntimeException("EnumeratedType name=" + this.name_ + " doesn't exist");
            }
        } else {
            enumeratedType = EnumeratedType.search(this.index_, (Collection)this.collection_);
            if (enumeratedType == null) {
                throw new RuntimeException("EnumeratedType index=" + this.index_ + " doesn't exist");
            }
        }
        return enumeratedType;
    }

    protected static EnumeratedType search(String string, Collection collection) {
        for (EnumeratedType enumeratedType : collection) {
            if (!enumeratedType.name_.equals(string)) continue;
            return enumeratedType;
        }
        return null;
    }

    protected static EnumeratedType search(int n, Collection collection) {
        for (EnumeratedType enumeratedType : collection) {
            if (enumeratedType.index_ != n) continue;
            return enumeratedType;
        }
        return null;
    }

    protected static Vector getEnumerates(Class clazz) {
        return (Vector)subclasses.get(clazz);
    }

    protected List getEnumerates() {
        return this.collection_;
    }

    protected boolean serializeByName() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (this.serializeByName()) {
            this.name_ = objectInput.readUTF();
        } else {
            this.index_ = objectInput.readInt();
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.serializeByName()) {
            objectOutput.writeUTF(this.name_);
        } else {
            objectOutput.writeInt(this.index_);
        }
    }
}

