/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.model3.collections.CollectionX;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.collections.SetX;
import net.model3.io.IOHelper;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.ModifierX;
import net.model3.lang.Pair;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.newfile.Path;

public class ClasspathIndex
implements Serializable {
    private static final long serialVersionUID = -5709190817891264459L;
    private static final Logger logger = LoggerHelper.getLogger();
    private ClassnameProvider _source;
    private Map<String, Set<String>> _annotationToClassnameMap = MapX.create();
    private Map<String, Set<String>> _parentToChildrenMap = MapX.create();
    private Map<String, Set<String>> _interfaceToImplementingClassesMap = MapX.create();
    private transient ClassLoader _classLoader;
    private transient Directory _cacheDirectory;

    public ClasspathIndex() {
    }

    public ClasspathIndex(ClasspathIndex ... classpathIndexArray) {
        for (ClasspathIndex classpathIndex : classpathIndexArray) {
            this.addIndex(classpathIndex);
        }
    }

    public ClasspathIndex(Class<?> clazz, Directory directory) {
        this._cacheDirectory = directory;
        Path<?> path = ClassX.getClasspathRoot(clazz, this.getClassLoader());
        if (path instanceof File) {
            this.loadJar((File)path);
        } else {
            this.loadDirectory((Directory)path);
        }
    }

    public ClasspathIndex(File file, Directory directory) {
        this._cacheDirectory = directory;
        this.loadJar(file);
    }

    public ClasspathIndex(Directory directory) {
        this.loadDirectory(directory);
    }

    public void addIndex(ClasspathIndex classpathIndex) {
        this._annotationToClassnameMap.putAll(classpathIndex._annotationToClassnameMap);
        this._parentToChildrenMap.putAll(classpathIndex._parentToChildrenMap);
        this._interfaceToImplementingClassesMap.putAll(classpathIndex._interfaceToImplementingClassesMap);
    }

    protected Map<String, Set<String>> getAnnotationToClassnameMap() {
        return this._annotationToClassnameMap;
    }

    protected Map<String, Set<String>> getInterfaceToImplementingClassesMap() {
        return this._interfaceToImplementingClassesMap;
    }

    public <T> Set<Class<? extends T>> getImplementors(Class<T> clazz) {
        Set<Class<T>> set = SetX.create();
        Set<String> set2 = this._interfaceToImplementingClassesMap.get(clazz.getName());
        if (set2 != null) {
            for (String string : set2) {
                Class<T> clazz2 = this.loadClass(string);
                if (clazz2 == null || clazz2.isInterface() || ModifierX.ABSTRACT.isIn(clazz2)) continue;
                set.add(clazz2);
            }
        }
        return set;
    }

    void loadJar(File file) {
        JarFileClassnameProvider jarFileClassnameProvider = new JarFileClassnameProvider(this.getClassLoader());
        jarFileClassnameProvider.setJarFile(file);
        this._source = jarFileClassnameProvider;
        if (!this.loadJarFromCache(file, jarFileClassnameProvider)) {
            this.load(jarFileClassnameProvider);
        }
    }

    boolean loadJarFromCache(File file, JarFileClassnameProvider jarFileClassnameProvider) {
        File file2;
        if (this._cacheDirectory != null && (file2 = new File(this._cacheDirectory, file.getName() + ".index")).exists()) {
            try {
                ClasspathIndex classpathIndex = new ClasspathIndex();
                classpathIndex.read(file2);
                if (jarFileClassnameProvider.equals(classpathIndex._source)) {
                    this._annotationToClassnameMap = classpathIndex._annotationToClassnameMap;
                    this._interfaceToImplementingClassesMap = classpathIndex._interfaceToImplementingClassesMap;
                    this._parentToChildrenMap = classpathIndex._parentToChildrenMap;
                    logger.debug((Object)"loaded cached index for {} from cache", (Object)file.getName());
                    return true;
                }
                try {
                    file2.delete();
                }
                catch (Exception exception) {
                    logger.debug((Object)"error deleting file {}", (Object)file2.getName());
                }
            }
            catch (Exception exception) {
                logger.debug((Object)"error loading cache file {}", (Object)file2.getCanonicalPath(), (Object)exception);
            }
        }
        return false;
    }

    void loadDirectory(Directory directory) {
        ClassesDirectoryClassnameProvider classesDirectoryClassnameProvider = new ClassesDirectoryClassnameProvider(this.getClassLoader());
        classesDirectoryClassnameProvider._classRoot = directory;
        this.load(classesDirectoryClassnameProvider);
    }

    void load(ClassnameProvider classnameProvider) {
        logger.debug((Object)"indexing {}", classnameProvider.getName());
        this._source = classnameProvider;
        ClassLoader classLoader = classnameProvider.getClassloader();
        for (String string : classnameProvider.getClassnames()) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                for (Annotation annotation : clazz.getAnnotations()) {
                    this.addAnnotation(annotation.getClass().getName(), clazz.getName());
                }
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    this.addInterfaceInstance(clazz2, string);
                }
                if (clazz.getSuperclass() == null) continue;
                this.addChildClass(clazz.getSuperclass().getName(), string);
            }
            catch (Throwable throwable) {
                logger.trace((Object)"error indexing {} skipping class", (Object)string);
            }
        }
    }

    void addChildClass(String string, String string2) {
        this.addValue(this._parentToChildrenMap, string, string2);
    }

    void addInterfaceInstance(Class<?> clazz, String string) {
        this.addValue(this._interfaceToImplementingClassesMap, clazz.getName(), string);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.addInterfaceInstance(clazz2, string);
        }
    }

    void addAnnotation(String string, String string2) {
        this.addValue(this._annotationToClassnameMap, string, string2);
    }

    void addValue(Map<String, Set<String>> map, String string, String string2) {
        Set<String> set = map.get(string);
        if (set == null) {
            set = SetX.create();
            map.put(string, set);
        }
        set.add(string2);
    }

    public ClassLoader getClassLoader() {
        if (this._classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this._classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public <T extends Annotation> Set<Class<?>> getAnnotatedClasses(Class<T> clazz) {
        String string = clazz.getName();
        Set<String> set = this._annotationToClassnameMap.get(string);
        if (set == null) {
            return Collections.emptySet();
        }
        Set<Class<?>> set2 = SetX.create();
        for (String string2 : set) {
            try {
                set2.add(this.getClassLoader().loadClass(string2));
            }
            catch (Exception exception) {
                logger.debug((Object)"error loading class {}", (Object)string2, (Object)exception);
            }
        }
        return set2;
    }

    public <T> List<Class<? extends T>> getChildClasses(Class<T> clazz) {
        return this.loadChildClasses(clazz, new ArrayList<Class<? extends T>>(), true);
    }

    public <T> List<Class<? extends T>> getInstantiableChildClasses(Class<T> clazz) {
        return this.loadChildClasses(clazz, new ArrayList<Class<? extends T>>(), false);
    }

    private <T> Class<T> loadClass(String string) {
        try {
            return this.getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            logger.debug((Object)"error loading class {}", (Object)string, (Object)exception);
            return null;
        }
    }

    private <T> List<Class<? extends T>> loadChildClasses(Class<? extends T> clazz, List<Class<? extends T>> list, boolean bl) {
        Set<String> set = this._parentToChildrenMap.get(clazz.getName());
        if (set != null) {
            for (String string : set) {
                Class<T> clazz2 = this.loadClass(string);
                if (bl || !ModifierX.ABSTRACT.isIn(clazz2)) {
                    list.add(clazz2);
                }
                this.loadChildClasses(clazz2, list, bl);
            }
        }
        return list;
    }

    public void write(File file) {
        try {
            Writer writer = new Writer();
            writer._out = new DataOutputStream(file.createOutputStream());
            writer.write();
            writer._out.close();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public void read(File file) {
        try {
            Reader reader = new Reader();
            reader._in = new DataInputStream(file.createInputStream());
            reader.read();
            reader._in.close();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    private class Reader {
        private DataInputStream _in;
        private Map<Integer, String> _strings = MapX.create();

        private Reader() {
        }

        void read() throws IOException {
            ClasspathIndex.this._source = (ClassnameProvider)this.readObject();
            ClasspathIndex.this._annotationToClassnameMap = this.readMap();
            ClasspathIndex.this._interfaceToImplementingClassesMap = this.readMap();
            ClasspathIndex.this._parentToChildrenMap = this.readMap();
        }

        <T> T readObject() throws IOException {
            byte[] byArray = new byte[this._in.readInt()];
            this._in.readFully(byArray);
            return IOHelper.deserializeObject(byArray);
        }

        public Map<String, Set<String>> readMap() throws IOException {
            int n = this._in.readInt();
            Map<String, Set<String>> map = MapX.create();
            for (int i = 0; i < n; ++i) {
                map.put(this.readString(), this.readSet());
            }
            return map;
        }

        public String readString() throws IOException {
            if (this._in.readByte() == 1) {
                return this._strings.get(this._in.readInt());
            }
            String string = this._in.readUTF();
            this._strings.put(this._strings.size(), string);
            return string;
        }

        public Set<String> readSet() throws IOException {
            int n = this._in.readInt();
            Set<String> set = SetX.create();
            for (int i = 0; i < n; ++i) {
                set.add(this.readString());
            }
            return set;
        }
    }

    private class Writer {
        private static final byte T_INDEX = 1;
        private static final byte T_STRING = 2;
        private DataOutputStream _out;
        private Map<String, Integer> _strings = MapX.create();

        private Writer() {
        }

        void write() throws IOException {
            this.writeObject(ClasspathIndex.this._source);
            this.write(ClasspathIndex.this._annotationToClassnameMap);
            this.write(ClasspathIndex.this._interfaceToImplementingClassesMap);
            this.write(ClasspathIndex.this._parentToChildrenMap);
        }

        void writeObject(Object object) throws IOException {
            byte[] byArray = IOHelper.serializeObject(object);
            this._out.writeInt(byArray.length);
            this._out.write(byArray);
        }

        public void write(Map<String, Set<String>> map) throws IOException {
            this._out.writeInt(map.size());
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                this.write(entry.getKey());
                this.write(entry.getValue());
            }
        }

        public void write(String string) throws IOException {
            if (this._strings.containsKey(string)) {
                this._out.write(1);
                this._out.writeInt(this._strings.get(string));
            } else {
                this._out.write(2);
                this._out.writeUTF(string);
                this._strings.put(string, this._strings.size());
            }
        }

        public void write(Set<String> set) throws IOException {
            this._out.writeInt(set.size());
            for (String string : set) {
                this.write(string);
            }
        }
    }

    static class NonDelegatingClassloader
    extends ClassLoader {
        private ClassLoader _siblingLoader;

        public NonDelegatingClassloader(ClassLoader classLoader) {
            super(ClassLoader.getSystemClassLoader());
            this._siblingLoader = classLoader;
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            try {
                URL uRL = this._siblingLoader.getResource(string);
                if (uRL != null) {
                    byte[] byArray = IOHelper.readFully(uRL.openStream());
                    return this.defineClass(string, byArray, 0, byArray.length);
                }
                return super.findClass(string);
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap(exception);
            }
        }
    }

    private class ClassesDirectoryClassnameProvider
    implements ClassnameProvider,
    Serializable {
        private static final long serialVersionUID = -4034485695974257414L;
        private Directory _classRoot;
        transient ClassLoader _classLoader;

        private ClassesDirectoryClassnameProvider(ClassLoader classLoader) {
            this._classLoader = new NonDelegatingClassloader(classLoader);
        }

        @Override
        public boolean isSerializable() {
            return true;
        }

        @Override
        public Object getName() {
            return this._classRoot.getCanonicalPath();
        }

        @Override
        public Collection<String> getClassnames() {
            List<String> list = ListX.create();
            for (File file : this._classRoot.files(true, "class")) {
                list.add(file.convertToClassname(this._classRoot));
            }
            return list;
        }

        @Override
        public ClassLoader getClassloader() {
            return this._classLoader;
        }
    }

    private static class JarFileClassnameProvider
    implements ClassnameProvider,
    Serializable {
        private static final long serialVersionUID = -1369083715387837817L;
        private transient File _jarFile;
        private String _jarFilename;
        private byte[] _jarFileMd5;
        private byte[] _jarFileSha;
        private long _jarFileSize;
        transient ClassLoader _classLoader;

        private JarFileClassnameProvider(ClassLoader classLoader) {
            this._classLoader = new NonDelegatingClassloader(classLoader);
        }

        @Override
        public Object getName() {
            return this._jarFilename;
        }

        @Override
        public boolean isSerializable() {
            return true;
        }

        public void setJarFile(File file) {
            this._jarFile = file;
            this._jarFilename = file.getName();
            Pair<byte[], byte[]> pair = this._jarFile.calculateMd5AndSha();
            this._jarFileMd5 = pair.getLeft();
            this._jarFileSha = pair.getRight();
        }

        @Override
        public Collection<String> getClassnames() {
            try {
                JarFile jarFile = new JarFile(this._jarFile.asFile());
                List<String> list = ListX.create();
                for (JarEntry jarEntry : CollectionX.collect(jarFile.entries())) {
                    if (!jarEntry.getName().endsWith(".class")) continue;
                    String string = jarEntry.getName();
                    string = string.replace("/", ".");
                    string = string.substring(0, string.length() - ".class".length());
                    list.add(string);
                }
                return list;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public ClassLoader getClassloader() {
            return this._classLoader;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            JarFileClassnameProvider jarFileClassnameProvider = (JarFileClassnameProvider)object;
            if (!Arrays.equals(this._jarFileMd5, jarFileClassnameProvider._jarFileMd5)) {
                return false;
            }
            if (!Arrays.equals(this._jarFileSha, jarFileClassnameProvider._jarFileSha)) {
                return false;
            }
            if (this._jarFileSize != jarFileClassnameProvider._jarFileSize) {
                return false;
            }
            return !(this._jarFilename == null ? jarFileClassnameProvider._jarFilename != null : !this._jarFilename.equals(jarFileClassnameProvider._jarFilename));
        }
    }

    private static interface ClassnameProvider {
        public Collection<String> getClassnames();

        public Object getName();

        public ClassLoader getClassloader();

        public boolean isSerializable();
    }
}

