/*
 * Decompiled with CFR 0.152.
 */
package net.model3.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.model3.collections.ListX;
import net.model3.io.IOHelper;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.newfile.Path;
import net.model3.newfile.PathIterator;

public class ClassX {
    private static final Logger logger = LoggerHelper.getLogger();
    public static final Class[] ZERO_ELEMENT_ARRAY = new Class[0];
    private static final Map<Class, Class> primitiveMap_ = new HashMap<Class, Class>();
    private static final Map<Class, Class> toPrimitiveMap_ = new HashMap<Class, Class>();

    private static void addPrimitive(Class clazz, Class clazz2) {
        primitiveMap_.put(clazz, clazz2);
        toPrimitiveMap_.put(clazz2, clazz);
    }

    public static String getShortName(Object object) {
        if (object instanceof Class) {
            return ClassX.getShortName((Class)object);
        }
        String string = object.getClass().getName();
        return ClassX.getShortName(string);
    }

    public static String getShortName(Class clazz) {
        return ClassX.getShortName(clazz.getName());
    }

    public static String getShortName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean isParent(Class clazz, Class clazz2) {
        if (clazz.equals(clazz2)) {
            return false;
        }
        return ClassX.isAssignable(clazz, clazz2);
    }

    public static Class getParentType(Class clazz, Class clazz2) {
        if (ClassX.isAssignable(clazz, clazz2)) {
            return clazz2;
        }
        if (ClassX.isAssignable(clazz2, clazz)) {
            return clazz;
        }
        return null;
    }

    public static Class getCommonParent(Class clazz, Class clazz2) {
        Class clazz3 = clazz;
        Class clazz4 = ClassX.getParentType(clazz3, clazz2);
        if (clazz4 != null) {
            return clazz4;
        }
        return null;
    }

    public static Class getCommonChild(Class clazz, Class clazz2) {
        Class clazz3 = ClassX.getCommonParent(clazz, clazz2);
        if (clazz3 == clazz) {
            return clazz2;
        }
        if (clazz3 == clazz2) {
            return clazz;
        }
        return null;
    }

    public static Class getReferenceClass(Class clazz) {
        if (clazz.isPrimitive()) {
            return toPrimitiveMap_.get(clazz);
        }
        return clazz;
    }

    public static Class getPrimitiveClass(Class clazz) {
        return primitiveMap_.get(clazz);
    }

    public static Field getField(Class clazz, String string) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        if (clazz.getSuperclass() != null) {
            return ClassX.getField(clazz.getSuperclass(), string);
        }
        return null;
    }

    public static <T> T getFieldValue(Object object, String string) {
        try {
            Field field = ClassX.getField(object.getClass(), string);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Directory getJarOrClassLocation(Class clazz) {
        try {
            String string = clazz.getName().replace('.', '/') + ".class";
            URL uRL = clazz.getClassLoader().getResource(string);
            String string2 = uRL.toExternalForm();
            if (string2.startsWith("jar:file:/")) {
                string2 = string2.substring("jar:".length(), string2.length() - string.length() - 2);
                uRL = new URL(string2);
                File file = new File(uRL);
                return file.getParent();
            }
            string2 = string2.substring(0, string2.length() - string.length());
            uRL = new URL(string2);
            return new Directory(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static String getJarOrDirectory(URL uRL, String string) {
        String string2 = uRL.toExternalForm();
        String string3 = string2.startsWith("jar:file:/") ? string2.substring("jar:".length(), string2.length() - string.length() - 2) : string2.substring(0, string2.length() - string.length());
        return string3;
    }

    public static List<Field> getFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ClassX.loadDeclaredFields(clazz, arrayList, true);
        return arrayList;
    }

    private static void loadDeclaredFields(Class clazz, List<Field> list, boolean bl) {
        for (Field field : clazz.getDeclaredFields()) {
            list.add(field);
        }
        if (bl && clazz.getSuperclass() != null) {
            ClassX.loadDeclaredFields(clazz.getSuperclass(), list, true);
        }
    }

    public static List<Method> getMethods(Class clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        ClassX.loadDeclaredMethods(clazz, arrayList, true);
        return arrayList;
    }

    private static void loadDeclaredMethods(Class clazz, List<Method> list, boolean bl) {
        for (Method method : clazz.getDeclaredMethods()) {
            list.add(method);
        }
        if (bl && clazz.getSuperclass() != null) {
            ClassX.loadDeclaredMethods(clazz.getSuperclass(), list, true);
        }
    }

    public static List<Class<?>> getClassesInPackage(Class clazz) {
        return ClassX.getClassesInPackage(clazz, false);
    }

    public static List<Class<?>> getClassesInPackage(Class clazz, boolean bl) {
        List<Class<?>> list = ListX.create();
        try {
            Path<?> path = ClassX.getClasspathRoot(clazz, clazz.getClassLoader());
            String string = clazz.getPackage().getName();
            String string2 = string.replace(".", "/");
            if (path instanceof File) {
                JarFile jarFile = new JarFile(path.asFile());
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().startsWith(string2) || !jarEntry.getName().endsWith(".class")) continue;
                    String string3 = jarEntry.getName();
                    string3 = string3.substring(0, string3.length() - ".class".length());
                    string3 = string3.replace("/", ".");
                    String string4 = ClassX.getPackageName(string3);
                    if ((!bl || !string4.startsWith(string)) && (bl || !string4.equals(string))) continue;
                    try {
                        list.add(Thread.currentThread().getContextClassLoader().loadClass(string3));
                    }
                    catch (Exception exception) {}
                }
            } else if (path instanceof Directory) {
                Directory directory = (Directory)path;
                Directory directory2 = (Directory)path;
                Directory directory3 = new Directory(directory2, string2);
                List<Directory> list2 = ListX.create();
                list2.add(directory3);
                if (bl) {
                    Iterator<Directory> iterator = new PathIterator(directory3).iterateDirectory();
                    while (iterator.hasNext()) {
                        list2.add(iterator.next());
                    }
                }
                for (Directory directory4 : list2) {
                    String string5 = directory4.getPathRelativeTo(directory);
                    string5 = string5.replace("/", ".");
                    string5 = string5.replace("\\", ".");
                    for (File file : directory4.files()) {
                        if (!file.getExtension().equalsIgnoreCase("class")) continue;
                        String string6 = string5 + "." + file.getBaseFilename();
                        try {
                            list.add(Thread.currentThread().getContextClassLoader().loadClass(string6));
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                throw new RuntimeException("don't know how to handle path type " + path.getClass());
            }
            return list;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Path<?> getClasspathRoot(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            String string = clazz.getName().replace('.', '/') + ".class";
            String string2 = classLoader.getResource(string).toExternalForm();
            String string3 = string2.substring(0, string2.length() - string.length());
            if (string3.startsWith("jar:file:/")) {
                string3 = string3.substring("jar:".length(), string3.length() - 2);
                return new File(new URL(string3));
            }
            if (string3.startsWith("file:/")) {
                return new Directory(new URL(string3));
            }
            throw new RuntimeException("don't know how to handle url " + string3);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static <T> Class<T> load(String string) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public static String getFilename(Class<?> clazz) {
        return ClassX.getFilename(clazz.getName());
    }

    public static String getFilename(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static String getSourceFilename(Class<?> clazz) {
        return ClassX.getSourceFilename(clazz);
    }

    public static String getSourceFilename(String string) {
        return string.replace('.', '/') + ".java";
    }

    public static List<URL> getResources(String string) {
        List<URL> list = ListX.create();
        ClassLoader classLoader = ClassX.getContextClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"error getting resources for {} using classloader {}", (Object)string, (Object)classLoader, (Object)exception);
        }
        return list;
    }

    static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static URL getResource(String string) {
        return Thread.currentThread().getContextClassLoader().getResource(string);
    }

    public static URL getResource(Object object, String string) {
        URL uRL = object.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        }
        if (uRL == null) {
            throw new RuntimeException("unable to find resource " + string);
        }
        return uRL;
    }

    public static InputStream getResourceAsStream(String string) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
    }

    public static String getResourceAsString(String string) {
        return IOHelper.readFully(new InputStreamReader(ClassX.getResourceAsStream(string)));
    }

    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T> Class<T> getParameterizedType(Class<?> clazz) {
        return ClassX.getParameterizedType(clazz, 0);
    }

    public static <T> Class<T> getParameterizedInterface(Class<?> clazz, Class<?> clazz2) {
        for (Type type : clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
            return ClassX.extractTypeFromActualTypeArgument(type2);
        }
        return null;
    }

    public static Class<?> extractTypeFromActualTypeArgument(Object object) {
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof ParameterizedType) {
            return (Class)((ParameterizedType)object).getRawType();
        }
        return null;
    }

    public static <T> Class<T> getParameterizedType(Class<?> clazz, int n) {
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getActualTypeArguments()[n];
            return ClassX.extractTypeFromActualTypeArgument(type2);
        }
        return null;
    }

    public static <T> T newInstance(String string) {
        try {
            Class<T> clazz = ClassX.load(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> clazz2, boolean bl) {
        Object object = clazz.getAnnotation(clazz2);
        if (bl && object == null) {
            object = (Annotation)ClassX.createDefaultAnnotationInstance(clazz2);
        }
        return object;
    }

    public static <T> T createDefaultAnnotationInstance(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                return method.getDefaultValue();
            }
        });
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        ClassX.addPrimitive(Boolean.class, Boolean.TYPE);
        ClassX.addPrimitive(Byte.class, Byte.TYPE);
        ClassX.addPrimitive(Character.class, Character.TYPE);
        ClassX.addPrimitive(Short.class, Short.TYPE);
        ClassX.addPrimitive(Integer.class, Integer.TYPE);
        ClassX.addPrimitive(Long.class, Long.TYPE);
        ClassX.addPrimitive(Float.class, Float.TYPE);
        ClassX.addPrimitive(Double.class, Double.TYPE);
    }
}

